<?php
include_once COMMON_DIR_PATH.'helpers'.DS."login-helper.php";
include_once COMMON_DIR_PATH.'helpers'.DS."utility-helper.php";
class AddonController extends AppController
{
	function before_execute()
	{
		parent::before_execute();
		if(!(LoginHelper::validate_admin_login()))
		{
			$this->flash($this->get_message('login failed'), $this->make_url('index/index'),0);
			exit;
		}		
		
		$pagecontent=$this->get_page_params();
		$pcontent='';
		
		if(isset($pagecontent[0]))
		    $pcontent=$pagecontent[0];
	}
	
	function dispatch_action()
	{
	
		$page=$this->get_page();
		$pagearray = explode("/",$page);
		$pagedata =array_slice($pagearray, 3);
		$pagedata =implode("/",$pagedata);
		
		if($this->get_addon_status($pagearray[2].'_enabled') !=1)
		{
		    $this->flash($this->get_message('invalid'), $this->make_url('index/index'),0);
		    exit;
		}
		
		include(ADDON_DIR_PATH.$pagearray[2].'/admin-dispatcher.php');
	}
		
	function manage_action()
	{
		$this->set_title ( $this->get_label ( 'manage addons' ) );
		$msg = $this->read_page_param ( 1 );
		$action = $this->read_page_param ( 2 );
		if ($msg == "addon_lic")
			$this->set_notice ( 'addon not purchased' );
		else if ($msg == "1")
			$this->set_notice ( 'addon mannual' );
		else if ($msg == "success" && $action=="install")
			$this->set_notice ( 'addon install success', 1 );
		else if ($msg == "success" && $action=="update")
			$this->set_notice ( 'addon update success', 1 );
		else if ($msg == "failed")
			$this->set_notice ( 'addon failed' );
		else if ($msg == "5")
			$this->set_notice ( 'addon folder' );
		else if ($msg == "3")
			$this->set_notice ( 'addon min_version' );
		else if ($msg == "6")
			$this->set_notice ( 'folder copy failed' );
		$this->xyz_cls_addon_include ( "addon.php", "" );
		
		$license_key = LICENSE_KEY;
		$pcode = PRODUCT_CODE;
		$url = 'http://validator.xyzscripts.com/index.php?page=index/updation/' . $pcode . '/' . $license_key;
		$data_return = '';
	
		if (ini_get ( 'allow_url_fopen' ) == 1 && $data = fopen ( $url, "r" )) {
			while ( ! feof ( $data ) )
				$data_return .= fgetc ( $data );
			fclose ( $data );
		} elseif (function_exists ( 'curl_init' )) {
			$ch = curl_init ();
			curl_setopt ( $ch, CURLOPT_URL, $url );
			curl_setopt ( $ch, CURLOPT_HEADER, 0 );
			curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, 1 );
			$data_return = curl_exec ( $ch );
			curl_close ( $ch );
		}
	
		$this->set_variable ( 'data_return', $data_return, 0 );
	
	}
	
	function install_action()
	{
		$addon_code=$this->read_page_param(1);
		$folder_name=$this->read_page_param(2);           // addon folder name
		$version=$this->read_page_param(3);
		$min_version=$this->read_page_param(4);
		$action=$this->read_page_param(5);
	
		$pcode=PRODUCT_CODE;
		$license_key=LICENSE_KEY;
		if($version < $min_version)
		{
			header("Location: ".$this->make_url("addon/manage/3"));
			exit;
		}
		$url = "http://validator.xyzscripts.com/index.php?page=license/php_addon_download/".$pcode."/".$addon_code."/".$_SERVER['HTTP_HOST']."/".$license_key;
		$downloadTime=time();
		$advset=array();
		$advset['headers'][]='xyz_php_download_time: '.$downloadTime;
		$license=$downloadTime.$license_key;
		$hash_licen=md5($license);
		$advset['headers'][]='xyz_php_download_hash: '.$hash_licen;
		$contents = $this->xyz_getpage($url,'',false,'',$advset);
		$zip_content=$contents['content'];
		$zip_content_error = substr($zip_content, 0, 5);
	
		if($zip_content=='-1')
		{
			header("Location: ".$this->make_url("addon/manage/addon_lic"));
			exit;
		}
		else{
			$targetfolder = realpath(dirname(__FILE__) . '/../../')."/data/addons";
			if (!is_dir($targetfolder))
			{
				$makedirectory=mkdir($targetfolder);
				if($makedirectory==false)
					header("Location: ".$this->make_url("addon/manage/5"));
			}
	
			$targetfolder = $targetfolder."/auto_install/";
	
	
			if (!is_dir($targetfolder))
			{
				chmod($targetfolder,777);
				$makedirectory=mkdir($targetfolder);
				if($makedirectory==false)
					header("Location: ".$this->make_url("addon/manage/5"));
			}
	
	
			$er_str="error";
			$error_check=strcmp($zip_content_error,$er_str );
	
			if($error_check==0)
			{
				$er_msg=substr($zip_content, 6);
				header("Location: ".$this->make_url("addon/manage/1/".$er_msg));
			}
	
			else if($zip_content!='')
			{
				file_put_contents($targetfolder.$folder_name.'.zip',$zip_content);
	
				$zip = new ZipArchive;
				if ($zip->open($targetfolder.$folder_name.'.zip') === TRUE)
				{
					$zip->extractTo($targetfolder);
					$zip->close();
	
					$source = $targetfolder.$folder_name;
					$dest = ADDON_DIR_PATH.$folder_name;
					$res_error=UtilityHelper::xyz_folder_copy($source, $dest);
	
					if($res_error==1)
					{
						if(file_exists($targetfolder.$folder_name.".zip")==1)
						{
							unlink($targetfolder.$folder_name.".zip");
							UtilityHelper::xyz_folder_delete($source);
	
						}
	
						header("Location: ".$this->make_url("addon/manage/success/".$action));
					}
					else
					{
						header("Location: ".$this->make_url("addon/manage/6"));
					}
				}
				else
				{
					header("Location: ".$this->make_url("addon/manage/failed"));
				}
	
			}
	
		}
	}
	
	function xyz_getpage($url, $ref='', $ctOnly=false, $fields='', $advSettings='',$ch=false) {
	
		if(!$ch)
			$ch = curl_init($url);
		else
			curl_setopt($ch, CURLOPT_URL, $url);
	
		$ccURL = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
		static $curl_loops = 0; static $curl_max_loops = 20; global $xyzsmap_gCookiesArr;
	
		$cookies = '';
		if (is_array($xyzsmap_gCookiesArr))
			foreach ($xyzsmap_gCookiesArr as $cName=>$cVal)
			$cookies .= $cName.'='.$cVal.'; ';
	
	
		if ($curl_loops++ >= $curl_max_loops){
			$curl_loops = 0; curl_close($ch);return false;
		}
		$headers = array();
	
		if ($fields!='')
			$field_type="POST";
		else
			$field_type="GET";
	
	
		$headers[] = 'Cache-Control: max-age=0';
		$headers[] = 'Connection: Keep-Alive';
		$headers[]='Referer: '.$url;
		$headers[]='User-Agent: Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.22 Safari/537.36';
		if($field_type=='POST')
			$headers[]='Content-Type: application/x-www-form-urlencoded';
	
		if (isset($advSettings['liXMLHttpRequest'])) {
			$headers[] = 'X-Requested-With: XMLHttpRequest';
		}
		if (isset($advSettings['Origin'])) {
			$headers[] = 'Origin: '.$advSettings['Origin'];
		}
		if ($field_type=='GET')
			$headers[]='Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8';
		else
			$headers[]='Accept: */*';
	
		$headers[]='Accept-Encoding: deflate,sdch';
		$headers[] = 'Accept-Language: en-US,en;q=0.8';
	
		if(isset($advSettings['noSSLSec'])){
			curl_setopt ($ch, CURLOPT_SSL_VERIFYHOST, 0); curl_setopt ($ch, CURLOPT_SSL_VERIFYPEER, 0);
		}
	
		if(isset($advSettings['proxy']) && $advSettings['proxy']['host']!='' && $advSettings['proxy']['port']!==''){
			curl_setopt($ch, CURLOPT_TIMEOUT, 4);  curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 4);
			curl_setopt( $ch, CURLOPT_PROXYTYPE, CURLPROXY_HTTP ); curl_setopt( $ch, CURLOPT_PROXY, $advSettings['proxy']['host'] );
			curl_setopt( $ch, CURLOPT_PROXYPORT, $advSettings['proxy']['port'] );
			if ( isset($advSettings['proxy']['up']) && $advSettings['proxy']['up']!='' ) {
				curl_setopt( $ch, CURLOPT_PROXYAUTH, CURLAUTH_ANY ); curl_setopt( $ch, CURLOPT_PROXYUSERPWD, $advSettings['proxy']['up'] );
			}
		}
		if(isset($advSettings['headers'])){
			$headers = array_merge($headers, $advSettings['headers']);
		}
		curl_setopt($ch, CURLOPT_HEADER, true);     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_COOKIE, $cookies); curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLINFO_HEADER_OUT, true);  if (is_string($ref) && $ref!='') curl_setopt($ch, CURLOPT_REFERER, $ref);
		curl_setopt($ch, CURLOPT_USERAGENT, (( isset( $advSettings['UA']) && $advSettings['UA']!='')?$advSettings['UA']:"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.44 Safari/537.36"));
		if ($fields!=''){
			curl_setopt($ch, CURLOPT_POST, true); curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
		} else { curl_setopt($ch, CURLOPT_POST, false); curl_setopt($ch, CURLOPT_POSTFIELDS, '');  curl_setopt($ch, CURLOPT_HTTPGET, true);
		}
		curl_setopt($ch, CURLOPT_TIMEOUT, 60);  curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
		$content = curl_exec($ch);
		$errmsg = curl_error($ch);  if (isset($errmsg) && stripos($errmsg, 'SSL')!==false) {
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);  $content = curl_exec($ch);
		}
		if (strpos($content, "\n\n")!=false && strpos($content, "\n\n")<100)
			$content = substr_replace($content, "\n", strpos($content,"\n\n"), strlen("\n\n"));
		if (strpos($content, "\r\n\r\n")!=false && strpos($content, "\r\n\r\n")<100)
			$content = substr_replace($content, "\r\n", strpos($content,"\r\n\r\n"), strlen("\r\n\r\n"));
		$ndel = strpos($content, "\n\n"); $rndel = strpos($content, "\r\n\r\n");
		if ($ndel==false) $ndel = 1000000; if ($rndel==false) $rndel = 1000000; $rrDel = $rndel<$ndel?"\r\n\r\n":"\n\n";
		list($header, $content) = explode($rrDel, $content, 2);
		if ($ctOnly!==true) {
			$fullresponse = curl_getinfo($ch); $err = curl_errno($ch); $errmsg = curl_error($ch); $fullresponse['errno'] = $err;
			$fullresponse['errmsg'] = $errmsg;  $fullresponse['headers'] = $header; $fullresponse['content'] = $content;
		}
		$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE); $headers = curl_getinfo($ch);
	
		if (empty($headers['request_header'])) $headers['request_header'] = 'Host: None'."\n";
	
		$results = array(); preg_match_all('|Host: (.*)\n|U', $headers['request_header'], $results);
		$ckDomain = str_replace('.', '_', $results[1][0]);  $ckDomain = str_replace("\r", "", $ckDomain);
		$ckDomain = str_replace("\n", "", $ckDomain);
	
	
		$results = array(); $cookies = '';  preg_match_all('|Set-Cookie: (.*);|U', $header, $results); $carTmp = $results[1];
		preg_match_all('/Set-Cookie: (.*)\b/', $header, $xck); $xck = $xck[1];
		//$clCook = array();
		if (isset($advSettings['cdomain']) &&  $advSettings['cdomain']!=''){
			foreach ($carTmp as $iii=>$cTmp)
				if (stripos($xck[$iii],'Domain=')===false || stripos($xck[$iii],'Domain=.'.$advSettings['cdomain'].';')!==false){
				$temp = explode('=',$cTmp,2); $xyzsmap_gCookiesArr[$temp[0]]=$temp[1];
			}
		}
		else {
			foreach ($carTmp as $cTmp){
				$temp = explode('=',$cTmp,2);
				$xyzsmap_gCookiesArr[$temp[0]]=$temp[1];
			}
		}
	
		/*foreach ($carTmp as $cTmp){
		 $temp = explode('=',$cTmp,2);
		}*/
	
		$rURL = '';
	
		if ($http_code == 200 && stripos($content, 'http-equiv="refresh" content="0; url=&#39;')!==false ) {
			$http_code=301; $rURL = xyzsmap_substring($content, 'http-equiv="refresh" content="0; url=&#39;','&#39;"');
			$xyzsmap_gCookiesArr = array();
		}
		elseif ($http_code == 200 && stripos($content, 'location.replace')!==false ) {
			$http_code=301; $rURL = xyzsmap_substring($content, 'location.replace("','"');
		}
		if ($http_code == 301 || $http_code == 302 || $http_code == 303){
			if ($rURL!='') {
				$rURL = str_replace('\x3d','=',$rURL); $rURL = str_replace('\x26','&',$rURL);
				$url = @parse_url($rURL);
			} else { $matches = array(); preg_match('/Location:(.*?)\n/', $header, $matches); $url = @parse_url(trim(array_pop($matches)));
			} $rURL = '';
			if (!$url){
				$curl_loops = 0;curl_close($ch); return ($ctOnly===true)?$content:$fullresponse;
			}
			$last_urlX = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL); $last_url = @parse_url($last_urlX);
			if (!$url['scheme']) $url['scheme'] = $last_url['scheme'];  if (!$url['host']) $url['host'] = $last_url['host'];
			if (!$url['path']) $url['path'] = $last_url['path']; if (!isset($url['query'])) $url['query'] = '';
			$new_url = $url['scheme'] . '://' . $url['host'] . $url['path'] . ($url['query']?'?'.$url['query']:'');
			return xyzsmap_getpage($new_url, $last_urlX, $ctOnly, '', $advSettings, $ch);
		} else { $curl_loops=0;curl_close($ch); return ($ctOnly===true)?$content:$fullresponse;
		}
	}
	
	
	
		
	function settings_action()
	{
		$addon=$this->read_page_param(1);
		$this->set_variable('addon',$addon);
		$this->set_title($this->get_label('addon settings type',array('x'=>strtoupper($addon))));
		$pluginarray=array();
		
		if(is_dir(ADDON_DIR_PATH))
		{
			$folders=array_diff(scandir(ADDON_DIR_PATH), array('..', '.'));
			
			foreach($folders as $folder)
			{
				if(is_dir(ADDON_DIR_PATH.$folder))
				    $pluginarray[0][]=$folder;
			}
		}
			
		$this->set_array('pluginarray',$pluginarray);
		
	}
	
};
?>