<?php
include_once COMMON_DIR_PATH.DS.'helpers'.DS."login-helper.php";
include_once COMMON_DIR_PATH.'helpers'.DS."utility-helper.php";
include_once COMMON_DIR_PATH.'helpers'.DS."image-helper.php";

class CategoryController extends AppController
{

	function before_execute()
	{
		if(LoginHelper::validate_admin_login()==0)
			{
				$this->flash($this->get_message('login failed'), $this->make_url('index/index'),0);
			}
	}
	
	function category_price_mapping_action()
	{
		$this->set_title($this->get_label('category price mapping'));
		$db= DBLayer::get_instance();
		
		
		$row=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."categories WHERE pid=0 ORDER BY name");
		$this->set_result('row',$row);
		
		$oldcat_list=Settings::get_instance()->read('category_price_mapping');
		$this->set_variable('oldcat_list',$oldcat_list);
		
		if($_POST)
		{
			$allcat_list=$this->get_child_ids(0);
			
			
			$allcat_list_arr=explode('_',$allcat_list);
			$count=count($allcat_list_arr);
			$check_str="";
			if($count >0)
			{
				for($i=0;$i<$count;$i++)
				{
					if($allcat_list_arr[$i]!="")
					{
						if(isset($_POST['ca'.$allcat_list_arr[$i]]) && $_POST['ca'.$allcat_list_arr[$i]]==1)
						{
							if($check_str=="")
							$check_str=$allcat_list_arr[$i];
							else 
							$check_str.='_'.$allcat_list_arr[$i];
						}
					}
				}
			}
			
			Settings::get_instance()->update('category_price_mapping',$check_str);
			
			$this->flash($this->get_message('successfully updated the mapping'), $this->make_url('category/category_price_mapping'));
			exit;
			
			
		}
		
		
		
		
		
	}
	
	function change_priority_action()
	{
	
	
	    $db= DBLayer::get_instance();
	$id=$this->read_page_param(1);
	$operation=$this->read_page_param(2);

	if(!$this->is_valid($id))
	{
		$this->flash($this->get_message('invalid id'), $this->make_url('category/manage'),0);
		exit;
	}
	
	 $priority=$db->read_single_column("select `priority` from ".TABLE_PREFIX."categories where `id`=?",array($id));

	if($operation==1)
	{
	$newpriority=$priority-1;
	}
	else
	{
		$newpriority=$priority+1;
	}
	
	
	$parentid=$this->get_pid($id);
	
	
	$newpriorityid=$db->read_single_column("select id from ".TABLE_PREFIX."categories where priority=? and pid=? limit 0,1",array($newpriority,$parentid));
	
	$db->execute_query("update ".TABLE_PREFIX."categories set priority=? where id=?",array($priority,$newpriorityid));
	
	$db->execute_query("update ".TABLE_PREFIX."categories set priority=? where id=?",array($newpriority,$id));
		
	$this->flash($this->get_message('priority update success'), $this->make_url('category/manage/'.$parentid));
	exit;
	
}
	function add_action()
	{
		$this->set_title($this->get_label('add cat'));
		
		
		$db= DBLayer::get_instance();
	
		if($_POST)
		$pid=$this->read_post_param('pid');
		else 
		$pid=$this->read_page_param(1);	
		
		$language_enabled=Settings::get_instance()->read('language_enabled');
		
		if(!$pid || $pid=="")
		$pid=0;

				
		if($pid!=0)
		{
			if(!$this->is_valid($pid))
			{
				$this->flash($this->get_message('parent invalid'), $this->make_url('category/manage/0'),0);
				die;
			}
		}
		
		
		
		
		$parent_level=$this->get_level($pid);
		
		$category="";
		$keyword='';
		$description='';
$logo='';
		if($_POST)
		{
			
			$premium_price=$this->read_post_param('premium_price');
			$category=$this->read_post_param('category');
			$keyword=$this->read_post_param('keyword');
			$description=$this->read_post_param('description');
			
			
			
			
			if($pid ==0)
			{
				$logo=$_FILES['image']['name'];
				$logo_exten=strtolower(substr($logo,-4));
			}	
			
			
			if($language_enabled ==1)
			{
			$localedata=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."locale WHERE status=1 OR name='".DEFAULT_LOCALE."'");
			$locale1='';
			$locale2=array();
			while($localerow=$localedata->fetch_assoc())
			{
				$submitvalue=trim($this->read_post_param($localerow['id'].'_category_name'));
				$submitvalue1=trim($this->read_post_param($localerow['id'].'_keyword'));
				$submitvalue2=trim($this->read_post_param($localerow['id'].'_description'));
				
				$this->set_variable($localerow['id'].'_category_name',$submitvalue);
				$this->set_variable($localerow['id'].'_keyword',$submitvalue1);
				$this->set_variable($localerow['id'].'_description',$submitvalue2);
				if($submitvalue !='')
				{
					if($locale1 !='')
					$locale1.=',';
					
					$locale1.=$localerow['id'].'_category_name=?';
					
					$locale2[]=$submitvalue;
				}
				
				if($submitvalue1 !='')
				{
					if($locale1 !='')
						$locale1.=',';
				
					$locale1.=$localerow['id'].'_keyword=?';
				
					$locale2[]=$submitvalue1;
				}
				if($submitvalue2 !='')
				{
					if($locale1 !='')
						$locale1.=',';
				
					$locale1.=$localerow['id'].'_description=?';
				
					$locale2[]=$submitvalue2;
				}
			}
			}
			
			
			
			
			$this->set_variable('premium_price', $premium_price);

			if($category=="")
			{
				$this->set_notice("mandatory");
			}
			else
			{
			
				if($pid!=0)
				{
					$res=$db->execute_query("select * from ".TABLE_PREFIX."categories where id=?",array($pid));
					$v=$res->fetch_assoc();
					$price=$v['premium_price'];
				}
				
				
				if($premium_price=="")
				{
					if($pid==0)
					$premium_price=0;
					else
					$premium_price=$price;
				}
				
		
				$count=$db->read_single_column("select count(id) from ".TABLE_PREFIX."categories where pid=? and name=?",array($pid,$category));
				if($count >0)
				{
					$this->set_notice("cat exists");
				}
				else if($pid ==0 && $logo!="" && $logo_exten!=".jpg" && $logo_exten!="jpeg" && $logo_exten!=".gif"  && $logo_exten!=".png")
				{
					$this->set_notice("image not supported");
				}
				else if($pid ==0 && $logo!="" && $_FILES["image"]["error"] > 0)
				{
					$this->set_notice("error occurred");
				}
				else
				{
					
					if($pid==0)
					{	
						$parent_level1=0;
						
						$priority=$db->read_single_column("select max(priority) from ".TABLE_PREFIX."categories WHERE pid=0");
						
						if($priority >=1)
							$newpriority=$priority+1;
						else
							$newpriority=1;
					}
					else
					{
					$parent_level1=$parent_level+1;
					
					$priority=$db->read_single_column("select max(priority) from ".TABLE_PREFIX."categories WHERE pid=?",array($pid));
					
					if($priority >=1)
					    $newpriority=$priority+1;
					    else
					        $newpriority=1;
					}
					
					if(Settings::get_instance()->read('enable_premium_listing')!=0)
					$res=$db->execute_query("INSERT INTO ".TABLE_PREFIX."categories (name,pid,level,premium_price,keyword,description,priority) values (?,?,?,?,?,?,?)",array($category,$pid,$parent_level1,$premium_price,$keyword,$description,$newpriority));
					else
					$res=$db->execute_query("INSERT INTO ".TABLE_PREFIX."categories (name,pid,level,keyword,description,priority) values (?,?,?,?,?,?)",array($category,$pid,$parent_level1,$keyword,$description,$newpriority));
					$lid=$res->get_last_id();
					$newsletteraddon_folder=$this->xyz_get_addon_folder_name("XYZCLSNLR");
					$newsletter_enable=$this->get_addon_status($newsletteraddon_folder.'_enabled');
					
					if($newsletter_enable ==1){
						$result_default=$db->execute_query("INSERT INTO ".TABLE_PREFIX."email_list(name,default_status,classifieds_cat_id) VALUES(?,?,?)",array($category,1,$lid));
					
					}
					
					
					
					
					if($language_enabled ==1){
					if($locale1 !='' && count($locale2) >0)
					{
						$locale2[]=$lid;
						$db->execute_query("UPDATE ".TABLE_PREFIX."categories SET ".$locale1." WHERE id=?",$locale2);
					}
					}
					
					
					
					if($pid ==0)
					{
						$sql="CREATE TABLE IF NOT EXISTS ".TABLE_PREFIX."customfields_".$lid." (
						`id` int NOT NULL auto_increment,
						`itemid` int NOT NULL,
						PRIMARY KEY  (`id`)
						) ENGINE=InnoDB CHARSET=".DB_CHARSET." COLLATE=".DB_COLLATION." AUTO_INCREMENT=1";
						$db->execute_query($sql);
					}
					$logo_name='';
					
					if($logo !="" && $pid ==0)
					{
						$logo_width1=80;
						$logo_height1=80;
						$time=time();
					
						if(!is_dir("../".DATA_DIR."/category"))
						mkdir("../".DATA_DIR."/category",0777);
						
						
					
						if(!is_dir("../".DATA_DIR."/category/".$lid))
						{
							mkdir("../".DATA_DIR."/category/".$lid,0777);
						}
					
						if($logo !="")
							{
								
								$logo_width=30;
								$logo_height=30;
								$logo_name=$time.$logo_exten;
								
								
							if(move_uploaded_file($_FILES["image"]["tmp_name"],"../".DATA_DIR."/category/".$lid."/big_".$logo_name))
							{
								$image=new ImageHelper("../".DATA_DIR."/category/".$lid."/big_".$logo_name);
								$image->resize_custom_limit($logo_width1,$logo_height1,"../".DATA_DIR."/category/".$lid."/big_".$logo_name);
							
								if(copy("../".DATA_DIR."/category/".$lid."/big_".$logo_name,"../".DATA_DIR."/category/".$lid."/".$logo_name))
								{
									$image=new ImageHelper("../".DATA_DIR."/category/".$lid."/".$logo_name);
									$image->resize_custom_limit($logo_width,$logo_height,"../".DATA_DIR."/category/".$lid."/".$logo_name);
								}
							}
							else
							{
								$this->flash($this->get_message('image upload failed'), $this->make_url('category/manage/').$pid,0);
								exit;
							}
						}
						
$db->execute_query("update ".TABLE_PREFIX."categories set image='$logo_name' where id='$lid'");
					}
					$this->flash($this->get_message('cat added'), $this->make_url('category/manage/').$pid);
					die;
				}
			}
		}
		
		
		if($language_enabled ==1){
		$localedata=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."locale WHERE status=1 OR name='".DEFAULT_LOCALE."'");
		$this->set_result('localedata',$localedata);
		}
		
		
		$this->set_variable("keyword",$keyword);
		$this->set_variable("description",$description);
		$this->set_variable("pid",$pid);
		$this->set_variable("category",$category);
	}
	function manage_action()
	{
		$this->set_title($this->get_label('manage category'));
		if(!($pid=$this->read_page_param(1)))
		{
			$pid=0;
		}
		

		if($pid!=0)
		{
			if(!$this->is_valid($pid))
			{
				$pid=0;
				$this->set_notice("parent invalid");
			}
		}
		
		
		$db= DBLayer::get_instance();
		$res=$db->execute_query("select * from ".TABLE_PREFIX."categories where pid=? order by priority asc",array($pid));
		$this->set_result("res",$res);
		

		$this->set_variable("cat_path",$this->get_category_path($pid,"category/manage"),0);
	}
	function edit_action()
	{
		$this->set_title($this->get_label('edit cat'));
		
		
		if($_POST)
		$id=$this->read_post_param('id');
		else 
		$id=$this->read_page_param(1);	
		
		$language_enabled=Settings::get_instance()->read('language_enabled');
		
		
		
		if(!$this->is_valid($id))
		{
			$this->flash($this->get_message('cat invalid'), $this->make_url('category/manage/0'),0);
			die;
		}
		
		
		$pid=DBLayer::get_instance()->read_single_column("select pid from ".TABLE_PREFIX."categories where id=?",array($id));
		


		$db= DBLayer::get_instance();
		
		if($_POST)
		{
			
			
			if($id <=109  && DEMO_MODE==TRUE)
			{
				$this->flash($this->get_message('demo mode'), $this->make_url('category/manage/0'),0);
				exit;
			}
			
			
			
			
			
			
			$category=$this->read_post_param('category');
			$premium_price=$this->read_post_param('premium_price');
			$keyword=$this->read_post_param('keyword');
			$description=$this->read_post_param('description');
			
			$price_apply=$this->read_post_param('price_apply');
			
			if($pid ==0)
			{
			$logo=$_FILES['image']['name'];
			$logo_exten=strtolower(substr($logo,-4));
			}
			
			
			$this->set_variable("id",$id);
			$this->set_variable("category",$category);
			$this->set_variable('premium_price', $premium_price);
			$this->set_variable('price_apply', $price_apply);
			
			
			
			
			if($language_enabled ==1){
			$localedata=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."locale WHERE status=1 OR name='".DEFAULT_LOCALE."'");
			$locale1='';
			$locale2=array();
			while($localerow=$localedata->fetch_assoc())
			{
				$submitvalue=trim($this->read_post_param($localerow['id'].'_category_name'));
				$submitvalue1=trim($this->read_post_param($localerow['id'].'_keyword'));
				$submitvalue2=trim($this->read_post_param($localerow['id'].'_description'));
				
				$this->set_variable($localerow['id'].'_category_name',$submitvalue);
				$this->set_variable($localerow['id'].'_keyword',$submitvalue1);
				$this->set_variable($localerow['id'].'_description',$submitvalue2);
				if($submitvalue !='')
				{
					if($locale1 !='')
						$locale1.=',';
				
					$locale1.=$localerow['id'].'_category_name=?';
				
					$locale2[]=$submitvalue;
				}
				
				if($submitvalue1 !='')
				{
					if($locale1 !='')
						$locale1.=',';
				
					$locale1.=$localerow['id'].'_keyword=?';
				
					$locale2[]=$submitvalue1;
				}
				if($submitvalue2 !='')
				{
					if($locale1 !='')
						$locale1.=',';
				
					$locale1.=$localerow['id'].'_description=?';
				
					$locale2[]=$submitvalue2;
				}
				
			}
			
			}
			
			
			
			if($pid!=0)
			{
				$res=$db->execute_query("select * from ".TABLE_PREFIX."categories where id=?",array($pid));
				$v=$res->fetch_assoc();
				$price=$v['premium_price'];
			}
			
			
			
			
			if($category=="" || $id=="")
			{
				$this->set_notice("mandatory");
			}
			else
			{
				
				if($premium_price=="")
				{
				$premium_price=0;
				}

				
				

				$count=$db->read_single_column("select count(id) from ".TABLE_PREFIX."categories where pid=? and name=? and id <> ?",array($pid,$category,$id));
				if($count >0)
				{
					$this->set_notice("cat exists");
				}
				else if($pid ==0 && $logo!="" && $logo_exten!=".jpg" && $logo_exten!="jpeg" && $logo_exten!=".gif"  && $logo_exten!=".png")
				{
					$this->set_notice("image not supported");
				}
				else if($pid ==0 && $logo!="" && $_FILES["image"]["error"] > 0)
				{
					$this->set_notice("error occurred");
				}
				else
				{
					
					if(Settings::get_instance()->read('enable_premium_listing')!=0)
					{
						$res=$db->execute_query("update ".TABLE_PREFIX."categories set name=?,premium_price=?,keyword=?,description=? where id=?",array($category,$premium_price,$keyword,$description,$id));
						if($price_apply==1)
						{
							$childs=$this->get_child_ids($id);
							
							
							if($childs !="")
							{
								$childs=substr($childs,0,-1);
								$childs_arr=explode('_',$childs);
							
								$child_str="";
								if(count($childs_arr) >0)
								{
									for($i=0;$i< count($childs_arr);$i++)
									{
										if($child_str=="")
										$child_str=" where id=".$childs_arr[$i];
										else 
										$child_str=$child_str." or id=".$childs_arr[$i];
									}
									
									if($child_str !="")
									$price_res=$db->execute_query("update ".TABLE_PREFIX."categories set premium_price=? ".$child_str." ",array($premium_price));
								}
							}
						}
					}
					else
					{
						$res=$db->execute_query("update ".TABLE_PREFIX."categories set name=?,keyword=?,description=? where id=?",array($category,$keyword,$description,$id));
					}
					
					
					if($language_enabled ==1){
					if($locale1 !='' && count($locale2) >0)
					{
						$locale2[]=$id;
						$db->execute_query("UPDATE ".TABLE_PREFIX."categories SET ".$locale1." WHERE id=?",$locale2);
					}
					}
					$logo_name='';
					
					
					if($logo!="" && $pid ==0)
					{
							
						$logo_width1=80;
						$logo_height1=80;
						
						$time=time();
						
						if(!is_dir("../".DATA_DIR."/category"))
						mkdir("../".DATA_DIR."/category",0777);
						
					
						if(!is_dir("../".DATA_DIR."/category/".$id))
						{
							mkdir("../".DATA_DIR."/category/".$id,0777);
						}
											
						if($logo!='')
						{
							
							$logo_width=30;
							$logo_height=30;
							$logo_name=$time.$logo_exten;
							$old_logo=$db->read_single_column("select image from ".TABLE_PREFIX."categories where id='$id'");
								
							if(move_uploaded_file($_FILES["image"]["tmp_name"],"../".DATA_DIR."/category/".$id."/big_".$logo_name))
							{
								$image=new ImageHelper("../".DATA_DIR."/category/".$id."/big_".$logo_name);
								$image->resize_custom_limit($logo_width1,$logo_height1,"../".DATA_DIR."/category/".$id."/big_".$logo_name);
							
								if(copy("../".DATA_DIR."/category/".$id."/big_".$logo_name,"../".DATA_DIR."/category/".$id."/".$logo_name))
								{
									$image=new ImageHelper("../".DATA_DIR."/category/".$id."/".$_FILES["image"]["name"]);
									$image->resize_custom_limit($logo_width,$logo_height,"../".DATA_DIR."/category/".$id."/".$logo_name);
								}
							
								$db->execute_query("update ".TABLE_PREFIX."categories set image='$logo_name' where id='$id'");
							
								if($old_logo !="")
								{
									if($old_logo !=$logo_name)
									{
										unlink("../".DATA_DIR."/category/".$id."/".$old_logo);
										unlink("../".DATA_DIR."/category/".$id."/big_".$old_logo);
									}
								}
							
							}
							else
							{
								$this->flash($this->get_message('image upload failed'), $this->make_url('category/manage/').$pid,0);
								exit;
							}
							
						}
					}
					
					$this->flash($this->get_message('cat edited'), $this->make_url('category/manage/'.$pid));
					die;
				}
			}
		}
		else
		{
			$res=$db->execute_query("select * from ".TABLE_PREFIX."categories where id=?",array($id));
			$row=$res->fetch_assoc();
			
			$this->set_variable("id",$row['id']);
			$this->set_variable("category",$row['name']);
			$this->set_variable("premium_price",$row['premium_price']);
			$this->set_variable("image",$row['image']);
			$this->set_variable("keyword",$row['keyword']);
			$this->set_variable("description",$row['description']);
			
			
			if($language_enabled ==1){
			$localedata=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."locale WHERE status=1 OR name='".DEFAULT_LOCALE."'");
			while($localerow=$localedata->fetch_assoc())
			{
				$this->set_variable($localerow['id'].'_category_name',$row[$localerow['id'].'_category_name']);
				$this->set_variable($localerow['id'].'_keyword',$row[$localerow['id'].'_keyword']);
				$this->set_variable($localerow['id'].'_description',$row[$localerow['id'].'_description']);
				
			}
			}
			
			
		}
		
		
		if($language_enabled ==1){
		$localedata=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."locale WHERE status=1 OR name='".DEFAULT_LOCALE."'");
		$this->set_result('localedata',$localedata);
		}
		
		
		$this->set_variable("pid",$pid);
	}
	function delete_action()
	{
		$id=$this->read_page_param(1);
		$this->set_variable('id',$id);
		
		
		$delcfflag=intval($this->read_page_param(2));
		
		if($id <=109  && DEMO_MODE==TRUE)
		{
			$this->flash($this->get_message('demo mode'), $this->make_url('category/manage/0'),0);
			exit;
		}
				
		if(!$this->is_valid($id))
		{
			$this->flash($this->get_message('cat invalid'), $this->make_url('category/manage/0'),0);
			exit;
		}
		
		$db= DBLayer::get_instance();
		
		
		$child_id=$db->read_single_column("select count(id) from ".TABLE_PREFIX."categories where pid=?", array($id));
		
		if($child_id >0)
		{
			$this->flash($this->get_message('child exists'), $this->make_url('category/manage'),0);
			exit;
		}
		else
		{
				$item_id=$db->read_single_column("select count(id) from ".TABLE_PREFIX."items where category=? AND user >0", array($id));
				
				if($item_id >0)
				{
					$this->flash($this->get_message('item exists'), $this->make_url('category/manage'),0);
					exit;
				}
				else 
				{
					$gpcount=$db->read_single_column("SELECT COUNT(id) FROM ".TABLE_PREFIX."customgroups WHERE catid=? AND status=1",array($id));
					$cfcount=$db->read_single_column("SELECT COUNT(id) FROM ".TABLE_PREFIX."customfields WHERE cat_id=? AND status=1",array($id));
					
					if(($gpcount ==0 && $cfcount ==0) || $delcfflag ==1)
					{
						$res=$db->execute_query("delete from ".TABLE_PREFIX."customgroups where catid=?",array($id));
						$da=$db->execute_query("SELECT id FROM ".TABLE_PREFIX."customfields where cat_id=?",array($id));
						
						$parentid=$db->read_single_column("select pid from ".TABLE_PREFIX."categories where id=?",array($id));
						
						if($parentid ==0)
						$res=$db->execute_query("DROP TABLE ".TABLE_PREFIX."customfields_".$id." ");
						else
						{
							$lastpidold=$this->get_last_parent_id($id);
							
							
							while($dadata=$da->fetch_assoc())
							{
								$db->execute_query("ALTER TABLE ".TABLE_PREFIX."customfields_".$lastpidold." DROP `field_".$dadata['id']."`");
								$db->execute_query("ALTER TABLE ".TABLE_PREFIX."customfields_".$lastpidold." DROP `sub_field_".$dadata['id']."`");
							}
							
							$da->set_result_index();
						}
								
						while($dadata=$da->fetch_assoc())
						{
							$db->execute_query("DELETE FROM ".TABLE_PREFIX."custom_dropdown_values WHERE cfid=?",array($dadata['id']));
						}		
						$res=$db->execute_query("delete from ".TABLE_PREFIX."customfields where cat_id=?",array($id));		
													
						$priority=$db->read_single_column("select priority from ".TABLE_PREFIX."categories where id=?",array($id));
						
						
						
						// newsletter addon support///
						
						$newsletteraddon_folder=$this->xyz_get_addon_folder_name("XYZCLSNLR");
						$newsletter_enable=$this->get_addon_status($newsletteraddon_folder.'_enabled');
						
						if($newsletter_enable ==1){
						
						
							
						    $list_id=DBLayer::get_instance()->read_single_column("select id from ".TABLE_PREFIX."email_list where classifieds_cat_id=?",array($id));
						
						
							if($list_id !="")
							{
								$db->execute_query("delete from ".TABLE_PREFIX."address_list_mapping where el_id=?",array($list_id));
								$db->execute_query("delete from ".TABLE_PREFIX."email_list where id=?",array($list_id));
								//echo $result->get_sql();die;
						
							}
						
						}
						
						/////////////////////////////////////////////////////////////////////////////////////////////
						
						

						
						
						
					    $res=$db->execute_query("delete from ".TABLE_PREFIX."categories where id=?",array($id));
					    
					    if($priority > 1)
					        $sqls=$db->execute_query("update ".TABLE_PREFIX."categories set priority=(priority-1) where priority >? AND pid=?",array($priority,$parentid));
					
					$mydir = "../".DATA_DIR."/category/".$id."/";
					$d = dir($mydir);
					if($d)
					{
						while($entry = $d->read())
						{
							if ($entry!= "." && $entry!= "..")
							{
								unlink("../".DATA_DIR."/category/".$id."/".$entry);
							}
						}
						$d->close();
						rmdir($mydir);
					}
				
					$this->flash($this->get_message('cat deleted'), $this->make_url('category/manage'));
					exit;
				}
				else 
				{
					
				}
			}
		}
	}
	function delete_image_action()
	{
	    $db=DBLayer::get_instance();
		$id=$this->read_page_param(1);
		
		if(!$this->is_valid($id))
		{
			$this->flash($this->get_message('cat invalid'), $this->make_url('category/manage/0'),0);
			die;
		}
		$old_logo=$db->read_single_column("select image from ".TABLE_PREFIX."categories where id='$id'");
		
				$db->execute_query("update ".TABLE_PREFIX."categories set image='' where id='$id'");
				
				$mydir = "../".DATA_DIR."/category/".$id."/";
				$d = dir($mydir);
				if($d)
				{
					while($entry = $d->read())
					{
						if ($entry!= "." && $entry!= "..")
						{
						    if($entry==$old_logo || $entry=="big_".$old_logo)
							unlink("../".DATA_DIR."/category/".$id."/".$entry);
						}
					}
					$d->close();
					rmdir($mydir);
				}	
				
				$this->flash($this->get_message('image deleted'), $this->make_url('category/edit/'.$id));
				exit;
	}
	
	
	function activate_action()
	{
	    $db= DBLayer::get_instance();
		$id=$this->read_page_param(1);
	
		if(!$this->is_valid($id))
		{
			$this->flash($this->get_message('cat invalid'), $this->make_url('category/manage/0'),0);
			die;
		}
		$result=$db->execute_query("UPDATE ".TABLE_PREFIX."categories set status=1 where id=?",array($id));

		$child_res=$db->execute_query("select id from ".TABLE_PREFIX."categories where pid=?",array($id));
		if($child_res->num_records>0)
		{
			while($child_row=$child_res->fetch_assoc())
			{
				$db->execute_query("UPDATE ".TABLE_PREFIX."categories set status=1 where id=?",array($child_row['id']));
		
				$sub_child_res=$db->execute_query("select id from ".TABLE_PREFIX."categories where pid=?",array($child_row['id']));
				if($sub_child_res->num_records>0)
				{
					while($sub_child_row=$sub_child_res->fetch_assoc())
					{
						$db->execute_query("UPDATE ".TABLE_PREFIX."categories set status=1 where id=?",array($sub_child_row['id']));
		
						$ss_child_res=$db->execute_query("select id from ".TABLE_PREFIX."categories where pid=?",array($sub_child_row['id']));
						if($ss_child_res->num_records>0)
						{
							while($ss_child_row=$ss_child_res->fetch_assoc())
							{
								$db->execute_query("UPDATE ".TABLE_PREFIX."categories set status=1 where id=?",array($ss_child_row['id']));
							}
						}
		
					}
				}
		
			}
		}
	
		
		// newsletter addon support///
		
		$newsletteraddon_folder=$this->xyz_get_addon_folder_name("XYZCLSNLR");
		$newsletter_enable=$this->get_addon_status($newsletteraddon_folder.'_enabled');
		
		if($newsletter_enable ==1){
		
		
		
		    $list_id=DBLayer::get_instance()->read_single_column("select id from ".TABLE_PREFIX."email_list where classifieds_cat_id=?",array($id));
		
		
			if($list_id !="")
			{
				$time=time();
				$query = "UPDATE ".TABLE_PREFIX."address_list_mapping SET status=1,last_update_time=? WHERE el_id= ?";//change status details from mapping table
				$result = $db->execute_query("$query",array($time,$list_id));
				//echo $result->get_sql();die;
		
			}
		
		}
		/////////////////////////////////////////////////////////////////////////////////////////////
		
		
		$pid=DBLayer::get_instance()->read_single_column("select pid from ".TABLE_PREFIX."categories where id=?",array($id));
		$this->flash($this->get_message('category activated'), $this->make_url('category/manage/'.$pid));
	}
	
	function block_action()
	{
	    $db= DBLayer::get_instance();
		$id=$this->read_page_param(1);
	
		if(!$this->is_valid($id))
		{
			$this->flash($this->get_message('cat invalid'), $this->make_url('category/manage/0'),0);
			die;
		}	
		$db->execute_query("UPDATE ".TABLE_PREFIX."categories set status=0 where id=?",array($id));

		$child_res=$db->execute_query("select id from ".TABLE_PREFIX."categories where pid=?",array($id));
		if($child_res->num_records>0)
		{
			while($child_row=$child_res->fetch_assoc())
			{
				$db->execute_query("UPDATE ".TABLE_PREFIX."categories set status=0 where id=?",array($child_row['id']));
			
				$sub_child_res=$db->execute_query("select id from ".TABLE_PREFIX."categories where pid=?",array($child_row['id']));
				if($sub_child_res->num_records>0)
				{
					while($sub_child_row=$sub_child_res->fetch_assoc())
					{
						$db->execute_query("UPDATE ".TABLE_PREFIX."categories set status=0 where id=?",array($sub_child_row['id']));
						
						$ss_child_res=$db->execute_query("select id from ".TABLE_PREFIX."categories where pid=?",array($sub_child_row['id']));
						if($ss_child_res->num_records>0)
						{
							while($ss_child_row=$ss_child_res->fetch_assoc())
							{
								$db->execute_query("UPDATE ".TABLE_PREFIX."categories set status=0 where id=?",array($ss_child_row['id']));
							}
						}				
					
					}
				}
			
			}
		}
		
		// newsletter addon support///
	
		$newsletteraddon_folder=$this->xyz_get_addon_folder_name("XYZCLSNLR");
		$newsletter_enable=$this->get_addon_status($newsletteraddon_folder.'_enabled');
		
		if($newsletter_enable ==1){
		
		
		
		    $list_id=DBLayer::get_instance()->read_single_column("select id from ".TABLE_PREFIX."email_list where classifieds_cat_id=?",array($id));
			
					
			if($list_id !="")
			{
				$time=time();
				$query = "UPDATE ".TABLE_PREFIX."address_list_mapping SET status=0,last_update_time=? WHERE el_id= ?";//change status details from mapping table
				$result = $db->execute_query("$query",array($time,$list_id));
				//echo $result->get_sql();die;
		
			}
		
		}
		
		/////////////////////////////////////////////////////////////////////////////////////////////
		
		
		
		
		$pid=DBLayer::get_instance()->read_single_column("select pid from ".TABLE_PREFIX."categories where id=?",array($id));
		
		$this->flash($this->get_message('category blocked'), $this->make_url('category/manage/'.$pid));
	}
	
	
};
?>
