<?php
include_once COMMON_DIR_PATH.DS.'helpers'.DS."utility-helper.php";
include_once COMMON_DIR_PATH.DS.'helpers'.DS."login-helper.php";
class ItemController extends AppController
{
function before_execute()
	{
		if(LoginHelper::validate_admin_login()==0)
			{
				$this->flash($this->get_message('login failed'), $this->make_url('index/index'),0);
			}
	}
	
	function pending_review_action()
	{
	    $db=DBLayer::get_instance();
		$this->set_title($this->get_label('pending reviews'));
	
	        $sql="SELECT count(r.id) as count,p.id,p.title FROM ".TABLE_PREFIX."items p INNER JOIN ".TABLE_PREFIX."product_rating r ON p.id=r.listing_id WHERE p.status=1 AND r.status=0 GROUP BY r.listing_id ORDER BY count DESC";
		$pagination = new Pagination($sql);
	
		$res=$pagination->get_result();
		$this->set_result("res",$res);
		$this->set_variable("pagination",$pagination->links(),0);
	}
	
	
	function manage_action()
	{
		
		$this->set_title($this->get_label('manage item'));

		
		if($_POST)
		{
			$type=$this->read_post_param("type");
			$status=$this->read_post_param("status");
			$featured=$this->read_post_param("featured");
			$categ=$this->read_post_param("catid");
		}
		else
		{
			$type=$this->read_page_param(1);
			$status=$this->read_page_param(2);
			$featured=$this->read_page_param(3);
			$categ=$this->read_page_param(4);
		}
		
		$exp=explode("-",$type);
		if($exp[0]=="page")
		$type=-1;
		
		
		
		if($type =="")
		$type=-1;
		
		if($status =="")
		$status=-2;
		
		if($featured =="")
		$featured=-1;
		
		if($categ =="")
		$categ=0;
		
		
		
		$type_str="";
		$status_str="";
		$featured_str="";
		$cat_str="";
		
		
		
		if($type !=-1)
		$type_str=" and type='".$type."' ";
		
		if($status !=-2)
		$status_str=" and status='".$status."' ";
		
		if($featured !=-1)
		{
			if($featured==0)
			$featured_str=" and featured=0 ";
			else if($featured==1)
			$featured_str=" and featured=1 ";
			else if($featured==2)
			$featured_str=" and home_listing=1 ";
			else if($featured==3)
			$featured_str="and featured=0 and home_listing=1 ";
			else if($featured==4)
			$featured_str="and featured=1 and home_listing=1 ";
		}
		
		
		$astr="";
		if($categ !=0)
		{
		//$cat_str=" and category='".$categ."' ";
			
			$childs=$this->display_childs($categ);
			$childs=substr($childs,0,-1);
			
			
			
			$astr="";
			
			if($childs !="")
			{
				$cudata_arr=explode("_",$childs);
			
				if(count($cudata_arr) >0)
				{
					for($k=0;$k< count($cudata_arr); $k++)
					{
					$astr.=" ,$cudata_arr[$k] ";
					}
				}
			}
			
			
			
			$astr='and category IN ('.$categ.$astr.') ';
		}
		
		
		$this->set_variable("type",$type);
		$this->set_variable("status",$status);
		$this->set_variable("featured",$featured);
		$this->set_variable("categ",$categ);
		
		
		
		$sql="select * from ".TABLE_PREFIX."items where user!=0 ".$astr.$type_str.$status_str.$featured_str." order by update_time desc";
		$pagination = new Pagination($sql,array());
		$res=$pagination->get_result(); 
		$this->set_result("res",$res);
		$this->set_variable("pagination",$pagination->links(),0);
		
		
		
		$pg=$pagination->get_page_number();
		$this->set_variable("pg","page-".$pg);
		
		
		
		$categories="<option value='0'>".$this->get_label('select')."</option>";
		$categories.=$this->get_category_display(0,0,$categ);
		$this->set_variable("categories",$categories,0);

	}

	
	
	function block_action()
	{
		$id=$this->read_page_param(1);
		$from=$this->read_page_param(2);
		$types=$this->read_page_param(3);
		$statuss=$this->read_page_param(4);
		$featureds=$this->read_page_param(5);
		$categs=$this->read_page_param(6);
		$pg=$this->read_page_param(7);
		
		
		
		$pgnew=explode("-",$pg);
		if($pgnew[0] !="page")
		$pg="";
		
		if($pg=="")
		$pg="page-1";
		
		if($types =="")
		$types=-1;
		
		if($statuss =="")
		$statuss=-2;
		
		if($featureds =="")
		$featureds=-1;
		
		if($categs =="")
		$categs=0;
		
		
		
		if(!$this->get_item_exists($id))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('item/manage'),0);
			exit;
		}
		
		$db=DBLayer::get_instance();
		if($id <=10 && DEMO_MODE==TRUE)
		{
			
			if($from ==1)
			{
				$uids=$db->read_single_column("select user from ".TABLE_PREFIX."items where id=?",array($id));
				$this->flash($this->get_message('demo mode'), $this->make_url('user/profile/'.$uids."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);
			}
			else if($from ==2)
			$this->flash($this->get_message('demo mode'), $this->make_url('item/preview/'.$id));
			else
			$this->flash($this->get_message('demo mode'), $this->make_url('item/manage'."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);
			
			
			exit;
		}
		
		$db->execute_query("update ".TABLE_PREFIX."items set status=0 where id=?",array($id));

		$res=$db->execute_query("select * from ".TABLE_PREFIX."items where id=? and status=0",array($id));
		if($res->num_records>0)
		{
			$row=$res->fetch_assoc();
			$details=$db->execute_query("select email,locale from ".TABLE_PREFIX."users where id=?",array($row['user']));
			$value=$details->fetch_assoc();	
			$res1=$db->execute_query("select * from ".TABLE_PREFIX."emailtemplates where id=2");
			$row1=$res1->fetch_assoc();
			$sub=$row1['sub'];
			$body=$row1['body'];
			if($row1[$value['locale'].'_sub']!='')
				$sub=$row1[$value['locale'].'_sub'];
			if($row1[$value['locale'].'_body']!='')
				$sub=$row1[$value['locale'].'_body'];
			
			$sub=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$sub);
			$sub=str_ireplace("{TITLE}",$row['title'],$sub);
				
			$body=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$body);
			$body=str_ireplace("{TITLE}",$row['title'],$body);
			UtilityHelper::send_mail($value['email'],$sub, $body);
			
		}
		
		
		
		if($from ==1)
		{
			$uids=$db->read_single_column("select user from ".TABLE_PREFIX."items where id=?",array($id));
			$this->flash($this->get_message('item blocked'), $this->make_url('user/profile/'.$uids."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg));
		}
		else if($from ==2)
			$this->flash($this->get_message('item blocked'), $this->make_url('item/preview/'.$id));
		else
			$this->flash($this->get_message('item blocked'), $this->make_url('item/manage'."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg));
		
		exit;

		
	}

	function activate_action()
	{
		$id=$this->read_page_param(1);
		$from=$this->read_page_param(2);
		$types=$this->read_page_param(3);
		$statuss=$this->read_page_param(4);
		$featureds=$this->read_page_param(5);
		$categs=$this->read_page_param(6);
		$pg=$this->read_page_param(7);
		
		$pgnew=explode("-",$pg);
		if($pgnew[0] !="page")
		$pg="";
		
		if($pg=="")
		$pg="page-1";
		
		if($types =="")
		$types=-1;
		
		if($statuss =="")
		$statuss=-2;
		
		if($featureds =="")
		$featureds=-1;
		
		if($categs =="")
		$categs=0;
		
		$db=DBLayer::get_instance();
		$uids=$db->read_single_column("select user from ".TABLE_PREFIX."items where id=?",array($id));
		
		if(!$this->get_item_exists($id))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('item/manage'),0);
			exit;
		}
		
		if($id <=10  && DEMO_MODE==TRUE)
		{
			if($from ==1)
			$this->flash($this->get_message('demo mode'), $this->make_url('user/profile/'.$uids."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);
			else if($from ==2)
			$this->flash($this->get_message('demo mode'), $this->make_url('item/preview/'.$id));
			else
			$this->flash($this->get_message('demo mode'), $this->make_url('item/manage'."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);
		
			exit;
		}
			
		$time_arr=getdate(time());
		$expiry=Settings::get_instance()->read("ad_expiry");
		$listing_mode=Settings::get_instance()->read('system_listing_mode');
		
		$premium_expiry=$db->read_single_column("select no_of_days from ".TABLE_PREFIX."items where id=?",array($id));
		
		$gmtime=gmmktime($time_arr['hours'],$time_arr['minutes'],$time_arr['seconds'],$time_arr['mon'],$time_arr['mday']+$expiry,$time_arr['year']);
		$premium_gmtime=gmmktime($time_arr['hours'],$time_arr['minutes'],$time_arr['seconds'],$time_arr['mon'],$time_arr['mday']+$premium_expiry,$time_arr['year']);
		
		
		

		
		$resdata=$db->execute_query("select * from ".TABLE_PREFIX."items where id=?",array($id));
		$rowdata=$resdata->fetch_assoc();
		
		$premiumad=$rowdata['featured'];
		
		$homead=$rowdata['home_listing'];
		$home_expiry=$rowdata['home_expiry'];
		$status=$rowdata['status'];
		$expr=$rowdata['expiry_time'];
		$paid_status=$rowdata['paid_status'];
		
		
		
		
		
		
		if($premiumad ==0)
		{
			$msg=$this->get_label('no');
			
			if($expr >0)	//active=>block=>activate
			{
				$db->execute_query("update ".TABLE_PREFIX."items set status=1,update_time=? where id=?",array(time(),$id));
				$db->execute_query("update ".TABLE_PREFIX."items set publish_time=? where id=? AND publish_time=0",array(time(),$id));
			}
			else // pending=>block=>activate
				$db->execute_query("update ".TABLE_PREFIX."items set status=1,update_time=?,expiry_time=?,publish_time=? where id=?",array(time(),$gmtime,time(),$id));
			
		}	
        else if($premiumad ==1)
        {
        	$prexpr=$db->read_single_column("select featured_expiry from ".TABLE_PREFIX."items where id=?",array($id));
        	$msg=$this->get_label('yes');
        	
        	
        	if($gmtime < $premium_gmtime && $paid_status ==0)
       		$gmtime=$premium_gmtime;
        	
        	if($premium_expiry ==0)//active=>block=>activate
        	{
        		if($expr >0)
        		{
        			$db->execute_query("update ".TABLE_PREFIX."items set status=1,update_time=? where id=?",array(time(),$id));
        			$db->execute_query("update ".TABLE_PREFIX."items set publish_time=? where id=? AND publish_time=0",array(time(),$id));
        		}
        		else
        			$db->execute_query("update ".TABLE_PREFIX."items set status=1,publish_time=?,update_time=?,expiry_time=? where id=?",array(time(),time(),$gmtime,$id));
        	}
        	else // pending=>block=>activate
        		$db->execute_query("update ".TABLE_PREFIX."items set status=1,publish_time=?,update_time=?,expiry_time=?,featured_expiry=? where id=?",array(time(),time(),$gmtime,$premium_gmtime,$id));
       }
		
        if($paid_status==1)
        {
        	$paid_days=$db->read_single_column("select paid_days from ".TABLE_PREFIX."items where id=?",array($id));
        	if($paid_days >0)
        	{
        		$current_new_expiry=$db->read_single_column("select expiry_time from ".TABLE_PREFIX."items where id=?",array($id));
        		
        		if($current_new_expiry > time())
        		{
        			$time_arr1=getdate($current_new_expiry);
        			$current_new_expiry=gmmktime($time_arr1['hours'],$time_arr1['minutes'],$time_arr1['seconds'],$time_arr1['mon'],$time_arr1['mday']+$paid_days,$time_arr1['year']);
        		}
        		else 
        		$current_new_expiry=gmmktime($time_arr['hours'],$time_arr['minutes'],$time_arr['seconds'],$time_arr['mon'],$time_arr['mday']+$paid_days,$time_arr['year']);
        	
        		$db->execute_query("update ".TABLE_PREFIX."items set expiry_time=?,paid_days=0 where id=?",array($current_new_expiry,$home_expiry,$id));
        	}				
        }
        	
        	if($homead ==1 && Settings::get_instance()->read('home_page_listing') ==1)
        	{
        		$home_days=$db->read_single_column("select home_days from ".TABLE_PREFIX."items where id=?",array($id));
        		
        		if($home_days >0)
        		{
	        		$home_expiry=gmmktime($time_arr['hours'],$time_arr['minutes'],$time_arr['seconds'],$time_arr['mon'],$time_arr['mday']+$home_days,$time_arr['year']);
	        		$current_new_expiry=$db->read_single_column("select expiry_time from ".TABLE_PREFIX."items where id=?",array($id));
	        		
	        		if($current_new_expiry < $home_expiry && $paid_status ==0)
	        		$current_new_expiry=$home_expiry;
	        		
	        		$db->execute_query("update ".TABLE_PREFIX."items set expiry_time=?,home_expiry=? where id=? AND home_listing=1",array($current_new_expiry,$home_expiry,$id));
        		}
        	}
        	
        	$db->execute_query("update ".TABLE_PREFIX."items set home_days=0,no_of_days=0 where id=?",array($id));
        	
        		
		
		$res=$db->execute_query("select * from ".TABLE_PREFIX."items where id=? and status=1",array($id));
		if(count($res)>0)
		{
			$row=$res->fetch_assoc();
			$details=$db->execute_query("select email,locale from ".TABLE_PREFIX."users where id=?",array($row['user']));
			$value=$details->fetch_assoc();
			$res1=$db->execute_query("select * from ".TABLE_PREFIX."emailtemplates where id=1");
			$row1=$res1->fetch_assoc();
			$sub=$row1['sub'];
			$body=$row1['body'];
			if($row1[$value['locale'].'_sub']!='')
				$sub=$row1[$value['locale'].'_sub'];
			if($row1[$value['locale'].'_body']!='')
				$sub=$row1[$value['locale'].'_body'];
			
			$sub=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$sub);
			$sub=str_ireplace("{TITLE}",$row['title'],$sub);
				
			$body=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$body);
			$body=str_ireplace("{TITLE}",$row['title'],$body);
			$body=str_ireplace("{PREMIUM}",$msg,$body);
			UtilityHelper::send_mail($value['email'],$sub, $body);
		}
	
		if($from ==1)
		{
			$uids=$db->read_single_column("select user from ".TABLE_PREFIX."items where id=?",array($id));
			$this->flash($this->get_message('item activated'), $this->make_url('user/profile/'.$uids."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg));
		}
		else if($from ==2)
			$this->flash($this->get_message('item activated'), $this->make_url('item/preview/'.$id));
		else
			$this->flash($this->get_message('item activated'), $this->make_url('item/manage'."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg));
		
		exit;
	}

	
	
	function preview_action()
	{
		$this->set_title($this->get_label('preview'));
		$id=$this->read_page_param(1);
		$db= DBLayer::get_instance();
		
		
		if(!$this->get_item_exists($id))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('item/manage'),0);
			exit;
		}
		
		
		
		
		$res=$db->execute_query("select * from ".TABLE_PREFIX."items where id=?",array($id));
		$row=$res->fetch_assoc();
		
		$this->set_variable("status",$row['status']);
		$this->set_variable("title",$row['title']);
		$this->set_variable("summary",nl2br($row['summary']),0);
		$this->set_variable("locality",nl2br($row['locality']));
		$this->set_variable("featured",$row['featured']);
		$this->set_variable("uid",$row['user']);
		$this->set_variable("featured_expiry",$row['featured_expiry']);
		$this->set_variable("home_listing",$row['home_listing']);
		$this->set_variable("home_expiry",$row['home_expiry']);
		$this->set_variable('paid_status',$row['paid_status']);
		
		$this->set_variable("price",$row['price']);
		$this->set_variable("video1",$row['video1']);
		$this->set_variable("video2",$row['video2']);
		$this->set_variable("marker",$row['marker']);
		
		if($row['address'] !="")
		$this->set_variable("address",$row['address']);
		else
		$this->set_variable("address",$this->get_label("na"));
		
		
		
		
		$this->set_variable("category",$this->get_category_path($row['category']),0);
		
		
		$this->set_variable("ids",$id);
		
		
		$home_page_listings=Settings::get_instance()->read('home_page_listing');
		if($home_page_listings < 0 || $home_page_listings =="")
		$home_page_listings=0;
		
		$this->set_variable('home_page_listings', $home_page_listings);
		
		
		
		if($row['type']==0)
		$this->set_variable("type",$this->get_label("type offered"));
		else
		$this->set_variable("type",$this->get_label("type wanted"));
		
		
		$this->set_variable("country",$db->read_single_column("select cname from ".TABLE_PREFIX."countries where ccode=?",array($row['country'])));
		
		$this->set_variable("state",$db->read_single_column("select sname from ".TABLE_PREFIX."states where scode=? and ccode=?",array($row['state'],$row['country'])));
		
		
		$this->set_variable("city",$db->read_single_column("select city from ".TABLE_PREFIX."cities where id=?",array($row['city'])));
		
		if($row['phone'] !="")
		$this->set_variable("phone",$row['phone']);
        else 
        $this->set_variable("phone",$this->get_label("na"));
		
		
        $iflag=0;
        $videocount=0;
        $imgcount=0;
		$strstring="";
		
		if($row['image'] !="")
		{
			$iflag=1;
			$imgcount=1;
			
			$this->set_variable("image",'<img src="../'.DATA_DIR."/".$row['id']."/".$row['image'].'"  border="0" width="120" height="80"/>',0);
			
			
			$str=$db->execute_query("select id from ".TABLE_PREFIX."images where itemid=?",array($id));
			while($srow=$str->fetch_assoc())
			{
				$strstring.=$srow['id'].'_';
				$imgcount=$imgcount+1;
			}
			
			$strstring="0_".$strstring;
			
			
		}
		else
		{
			$this->set_variable("image",$this->get_label("no image"));
		}
		
		$video11='';
		$video22='';
		
		if($row['video1'] !=='')
		$video11=$row['video1'];
		
		
		if($video11 =='')
		{
			if($row['video2'] !=='')
			$video11=$row['video2'];
		}
		else if($video11 !='')
		$video22=$row['video2'];
		
		
		if($video11 !=='')
		$iflag=1;
		
		if($video22 !=='')
		$iflag=1;
		
		
		
		
		
		if($row['video1'] !='')
		$videocount=$videocount+1;
		
		if($row['video2'] !='')
		$videocount=$videocount+1;
		
		
		
		
		
		
		
		
		$this->set_variable("strstring",$strstring);
		$this->set_variable("imgcount",$imgcount);
		$this->set_variable("videocount",$videocount);
		
		$this->set_variable("iflag",$iflag);
		
		
		
		if($row['url'] !="")
		$this->set_variable("url",$row['url']);
		else
		$this->set_variable("url",$this->get_label("na"));
			
			
			
		
		if($row['publish_time']!=0)
		$this->set_variable("publish_time",$this->get_date_format(2,$row['publish_time']));
 		else
		$this->set_variable("publish_time",$this->get_label("na"));
 	
 		
 		
 		if($row['update_time']!=0)
		$this->set_variable("update_time",$this->get_date_format(2,$row['update_time']));
		else
		$this->set_variable("update_time",$this->get_label("na"));

		if($row['expiry_time']!=0)
		$this->set_variable("expiry_time",$this->get_date_format(2,$row['expiry_time']));
		else
		$this->set_variable("expiry_time",$this->get_label("na"));
		
		
		
		
		
$ratecount=$db->read_single_column("select sum(rate) from ".TABLE_PREFIX."product_rating where listing_id=? and status=1",array($id));
$reviewcount=$db->read_single_column("select count(id) from ".TABLE_PREFIX."product_rating where listing_id=? and status=1",array($id));
		

		
		$averagerating=0;
		if($reviewcount >0)
		$averagerating=$ratecount/$reviewcount;
		
		$this->set_variable("ratecount",intval($ratecount));
		$this->set_variable("reviewcount",intval($reviewcount));
		$this->set_variable("averagerating",$averagerating);
		$this->set_variable("views_count",intval($row['views_counter']));
		
	}

	
	function popup_action()
	{
		
		
		$id=$this->read_page_param(1);
		$this->set_variable('id',$id);
	
		$gallerystring="";
		$galcnt=1;
		$videocount=0;
		$orgimagecount=0;
		
		$db= DBLayer::get_instance();
		$youtube_enabled=Settings::get_instance()->read('youtube_video_enable');
		
		$res=$db->execute_query("select * from ".TABLE_PREFIX."items where id=?",array($id));
		$row=$res->fetch_assoc();
		
		$addit_images=$db->execute_query("select * from ".TABLE_PREFIX."images where itemid=?",array($id));
		$addit_images_count=$addit_images->get_num_records();
		
		
		
		if($youtube_enabled ==1)
		{
		    
		    if($row['video1'] !='')
		        $videocount=$videocount+1;
		        
		        if($row['video2'] !='')
		            $videocount=$videocount+1;
		            
		}
		if($row['image'] !='')
		    $orgimagecount=1;
		    
		    
		    if($orgimagecount >0)
		    {
		        $str=$db->execute_query("select id from ".TABLE_PREFIX."images where itemid=?",array($id));
		        while($srow=$str->fetch_assoc())
		        {
		            if($strstring !='')
		                $strstring.='_';
		                
		                $strstring.=$srow['id'];
		        }
		        
		        $strstring="0_".$strstring;
		    }
		    
		    
		    $totalcount=intval($orgimagecount+$addit_images_count+$videocount);
		    
		    $subtotal=intval($orgimagecount+$addit_images_count);
		    
		    
		    $imgcnts=0;
		    if($row['image'] !="")
		    {
		        
		        
		        //	$gallerystring.='<img style="display:none;width:'.$dimensionarray[0].'px;height:'.$dimensionarray[1].'px;" id="zoom_1" class="zoomPreview img-responsive" src="'.DATA_DIR."/".$row['id']."/".$row['image'].'" data-zoom-image="'.DATA_DIR."/".$row['id']."/".$row['image'].'" title="'.$row['title'].'" />';
		        $gallerystring.="<img alt='Preview Image 1' src="."../".DATA_DIR."/".$row['id']."/".$row['image']."  data-image="."../".DATA_DIR."/".$row['id']."/".$row['image'].">";// data-description='Preview Image 1 Description'
		        $galcnt=$galcnt+1;
		        
		        $iflag=1;
		        
		        $imgcnts=$db->read_single_column("select count(id) from ".TABLE_PREFIX."images where itemid=?",array($id));
		        
		        if($imgcnts >0)
		            $imagecnts=$imgcnts+1;
		            else
		                $imagecnts=1;
		    }
		    
		    $this->set_variable("imagecnts",$imagecnts);
		    
		    
		    
		    
		    $ii=0;
		    while($addit_row=$addit_images->fetch_assoc())
		    {
		        $ii=$ii+1;
		        $gallerystring.="<img alt='Preview Image 1' src="."../".DATA_DIR."/".$id."/".$addit_row['image']."  data-image="."../".DATA_DIR."/".$id."/".$addit_row['image']." data-description='Preview Image 1 Description'>";
		        
		        
		        //$gallerystring.='<img style="display:none;width:'.$dimensionarray[0].'px;height:'.$dimensionarray[1].'px;" class="zoomPreview img-responsive" id="zoom_'.($galcnt).'" src="'.DATA_DIR."/".$id."/".$addit_row['image'].'" data-zoom-image="'.DATA_DIR."/".$id."/".$addit_row['image'].'" />';
		        $galcnt=$galcnt+1;
		    }
		    
		    $video11='';
		    $video22='';
		    
		    
		    if($youtube_enabled ==1)
		    {
		        
		        if($row['video1'] !=='')
		            $video11=$row['video1'];
		            
		            
		            if($video11 =='')
		            {
		                if($row['video2'] !=='')
		                    $video11=$row['video2'];
		            }
		            else if($video11 !='')
		                $video22=$row['video2'];
		                
		                
		                
		                
		                
		                if($video11 !=='')
		                {
		                    $video1array=explode('v=',$video11);
		                    if(isset($video1array[1]))
		                        $video111=$video1array[1];
		                        else
		                            $video111="";
		                            
		                            
		                            $gallerystring.="<img  data-type='youtube' data-videoid=".$video111."  data-description='You can include youtube videos easily!'>";
		                            
		                            $galcnt=$galcnt+1;
		                            
		                            
		                            $iflag=1;
		                }
		                
		                if($video22 !=='')
		                {
		                    $video2array=explode('v=',$video22);
		                    if(isset($video2array[1]))
		                        $video222=$video2array[1];
		                        else
		                            $video222="";
		                            
		                            
		                            $gallerystring.="<img  data-type='youtube' data-videoid=".$video222."  data-description='You can include youtube videos easily!'>";
		                            
		                            $galcnt=$galcnt+1;
		                            
		                            
		                            $iflag=1;
		                }
		                
		                
		    }
		    
		    if($detailstring !='')
		        $detailstring='<input type="hidden" name="xyz_gal_detailstring" id="xyz_gal_detailstring" value="'.$detailstring.'" />';
		        

		$this->set_variable('gallerystring',$gallerystring.$detailstring,0);	        
		$this->set_variable('videocount',$videocount);
	
	
	}
	function manage_image_action()
	{
		$this->set_title($this->get_label('manage gallery'));
		$db= DBLayer::get_instance();
		
		$id=$this->read_page_param(1);
		$this->set_variable('id',$id);
		
		
		if(!$this->get_item_exists($id))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('item/manage'),0);
			exit;
		}
				
		$firstimage=$db->read_single_column("select image from ".TABLE_PREFIX."items where id=?",array($id));
		
		$imagecnt=0;
		if($firstimage !='')
		$imagecnt=1;
		
		$res=$db->execute_query("select * from ".TABLE_PREFIX."items where id=?",array($id));
		$row=$res->fetch_assoc();
		
		$videocount=0;
		$video1="";
		$video2="";
		if($row['video1'] !="")
		{
			$videocount=$videocount+1;
			$video1=$row['video1'];
		}
		
		if($row['video2'] !="")
		{
			$videocount=$videocount+1;
			$video2=$row['video2'];
		}
		
		$this->set_variable('videocount',$videocount);
		$this->set_variable('video1',$video1);
		$this->set_variable('video2',$video2);
		$this->set_variable('imagecnt',$imagecnt);
		
		
		
		
		if($imagecnt ==0 && $videocount ==0)
		{
			$this->flash($this->get_message('no image found'), $this->make_url('item/manage'));
			exit;
		}
		
		
		$extraimage=$db->execute_query("select id,image from ".TABLE_PREFIX."images where itemid=?",array($id));
		$this->set_result('extraimage', $extraimage);
		
		$this->set_variable('firstimage', $firstimage);
		
		
		
	}
	

	
	function premium_action()
	{
		$this->set_title($this->get_label('make premium'));
		$db= DBLayer::get_instance();
		
		if($_POST)
		{
			$itemid=$this->read_post_param('itemid');
			$planid=$this->read_post_param('plan');
			$from=$this->read_post_param('from');
			$types=$this->read_post_param('types');
			$statuss=$this->read_post_param('statuss');
			$featureds=$this->read_post_param('featureds');
			$categs=$this->read_post_param('categs');
			$pg=$this->read_post_param('pg');
			
			$home=intval($this->read_post_param('home'));
			$paid=intval($this->read_post_param('paid'));
			$premium=intval($this->read_post_param('premium'));
		}
		else
		{
			$itemid=$this->read_page_param(1);
			$planid=0;
		    $from=$this->read_page_param(2);
			
		    $types=$this->read_page_param(3);
			$statuss=$this->read_page_param(4);
			$featureds=$this->read_page_param(5);
			$categs=$this->read_page_param(6);
			$pg=$this->read_page_param(7);
			
			$paid=0;
			$home=0;
			$premium=0;
		}
		
		
		
		$pgnew=explode("-",$pg);
		if($pgnew[0] !="page")
		$pg="";
		
		if($pg=="")
		$pg="page-1";
		
		if($types =="")
		$types=-1;
		
		if($statuss =="")
		$statuss=-2;
		
		if($featureds =="")
		$featureds=-1;
		
		if($categs =="")
		$categs=0;
		
		$this->set_variable("types", $types);
		$this->set_variable("statuss", $statuss);
		$this->set_variable("featureds", $featureds);
		$this->set_variable("categs", $categs);
		$this->set_variable("pg", $pg);
		$this->set_variable("from", $from);
		
		
		$this->set_variable("home",$home);
		$this->set_variable("paid",$paid);
		$this->set_variable("premium",$premium);
		
		
		
		$res12=$db->execute_query("select * from ".TABLE_PREFIX."items where id=?",array($itemid));
		$value=$res12->fetch_assoc();
		
		$uids=$value['user'];
		$org_status=$value['status'];
		$expiry=$value['featured_expiry'];
		$normal_expiry=$value['expiry_time'];
		$home_expiry=$value['home_expiry'];
		$already_paid=$value['paid_status'];
		$paid_days=$value['paid_days'];
		$catid=$value['category'];		
		
		
		
		$res=$db->execute_query("select i.*,c.premium_price,c.paid_post,c.pay_per_post,c.rate_per_post from ".TABLE_PREFIX."items i JOIN ".TABLE_PREFIX."categories c ON i.category=c.id where i.id=?",array($itemid));
		$this->set_result('res', $res);
		
		$res1=$db->execute_query("select * from ".TABLE_PREFIX."paymentplans where status=1");
		$this->set_result('res1', $res1);		
		
		
		$paid_listing_type=Settings::get_instance()->read('system_listing_mode');  //0 For Free Only   1 For Paid & Free     2 For Paid Only
		
		$paid_array=$this->get_paid_option($catid,$uids);
		

		$paid_compulsory=0;
		$paid_post=0;
		$pay_per_post=0;
			
		if($paid_listing_type >0)
		{
			$paid_array_data=explode('-',$paid_array);
	
			$paid_compulsory=$paid_array_data[0];
			$paid_post=$paid_array_data[1];
			$pay_per_post=$paid_array_data[2];
		}		
		
		
		
		
		$this->set_variable("paid_array",$paid_array);		
		$this->set_variable("paid_listing_type",$paid_listing_type);		
		
		
				
		
		
		if($itemid <=10  && DEMO_MODE==TRUE)
		{
			if($from ==1)
			$this->flash($this->get_message('demo mode'), $this->make_url('user/profile/'.$uids."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);
			else if($from ==2)
			$this->flash($this->get_message('demo mode'), $this->make_url('item/preview/'.$itemid),0);
			else
			$this->flash($this->get_message('demo mode'), $this->make_url('item/manage'."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);
		
			exit;
		}
		
				
		if(Settings::get_instance()->read('enable_premium_listing') ==0 && Settings::get_instance()->read('home_page_listing') ==0 && Settings::get_instance()->read('system_listing_mode') ==0)
		{
			if($from ==1)
			$this->flash($this->get_message('invalid operation'), $this->make_url('user/profile/'.$uids."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);
			else if($from ==2)
			$this->flash($this->get_message('invalid operation'), $this->make_url('item/preview/'.$itemid),0);
			else
			$this->flash($this->get_message('invalid operation'), $this->make_url('item/manage'."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);
			
			exit;
		}
		
		
		if(!$this->get_item_exists($itemid))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('item/manage'),0);
			exit;
		}
		
		if($_POST)
		{
			
		    if($planid !=0)
			{
				$planarr=explode("_",$planid);
				
				if($planarr[0] >0)
				$planid=$planarr[0];
				else
				$planid=0;
			}
			else 
			$planid=0;
						

			
			if($org_status==1 || $org_status ==-3)
			{
				$t=time();
				
				
				if($paid ==1 && Settings::get_instance()->read('system_listing_mode') >0 && $already_paid ==0 && $org_status ==-3)
				{
					if($paid_days ==0)
					$paid_days=Settings::get_instance()->read('ad_expiry');
					
					$normal_expiry=gmmktime(gmdate("H",$t),gmdate("i",$t),gmdate("s",$t),gmdate("m",$t),gmdate("d",$t)+$paid_days,gmdate("Y",$t));
					
					$db->execute_query("UPDATE ".TABLE_PREFIX."items set status=1,paid_status=1,paid_days=0,expiry_time=? where id=?",array($normal_expiry,$itemid));
				
				
				    $already_paid=1;
				}
				
				
				if($premium ==1 && Settings::get_instance()->read('enable_premium_listing') !=0)
				{
					if($planid==0)
					$num_days=Settings::get_instance()->read('default_premium_listing_period');
					else
					$num_days=$db->read_single_column("select num_days from ".TABLE_PREFIX."paymentplans where id=?",array($planid));
	
					if($expiry >0)
					$t2=gmmktime(gmdate("H",$expiry),gmdate("i",$expiry),gmdate("s",$expiry),gmdate("m",$expiry),gmdate("d",$expiry)+$num_days,gmdate("Y",$expiry));
					else
					$t2=gmmktime(gmdate("H",$t),gmdate("i",$t),gmdate("s",$t),gmdate("m",$t),gmdate("d",$t)+$num_days,gmdate("Y",$t));
					
					
					
					
					
					
					if($normal_expiry < $t2  && $already_paid ==0)
					$normal_expiry=$t2;
		
					$result=$db->execute_query("UPDATE ".TABLE_PREFIX."items set featured=?,featured_expiry=?,expiry_time=? where id=?",array(1,$t2,$normal_expiry,$itemid));
				
					$db->execute_query("DELETE FROM ".TABLE_PREFIX."notification WHERE itemid=? AND type=2",array($itemid));
				}
				
				
				
				$home_days=Settings::get_instance()->read('home_listing_days');
				
				if($home_expiry >0)
				$home_expiry_new=gmmktime(gmdate("H",$home_expiry),gmdate("i",$home_expiry),gmdate("s",$home_expiry),gmdate("m",$home_expiry),gmdate("d",$home_expiry)+$home_days,gmdate("Y",$home_expiry));
				else
				$home_expiry_new=gmmktime(gmdate("H",$t),gmdate("i",$t),gmdate("s",$t),gmdate("m",$t),gmdate("d",$t)+$home_days,gmdate("Y",$t));
				
				
				if($normal_expiry < $home_expiry_new  && $already_paid ==0)
				$normal_expiry=$home_expiry_new;
				
				
				if($home ==1 && Settings::get_instance()->read('home_page_listing') ==1)
				{
					$sq=$db->execute_query("UPDATE ".TABLE_PREFIX."items set home_listing=1,home_expiry=?,expiry_time=? where id=?",array($home_expiry_new,$normal_expiry,$itemid));
					
					$db->execute_query("DELETE FROM ".TABLE_PREFIX."notification WHERE itemid=? AND type=3",array($itemid));
					
				}
		   }
		   else 
		   {
			   	if($from ==1)
		   		$this->flash($this->get_message('item is not active'), $this->make_url('user/profile/'.$uids."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);
			   	else if($from ==2)
		   		$this->flash($this->get_message('item is not active'), $this->make_url('item/preview/'.$itemid),0);
			   	else
			   	$this->flash($this->get_message('item is not active'), $this->make_url('item/manage'."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);

			   	exit;
		   }
		
		
			if($from ==1)
			$this->flash($this->get_message('item updated'), $this->make_url('user/profile/'.$uids."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg));
			else if($from ==2)
			$this->flash($this->get_message('item updated'), $this->make_url('item/preview/'.$itemid));
			else	
			$this->flash($this->get_message('item updated'), $this->make_url('item/manage'."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg));
			
			exit;
		}
	


	}
	
	
	function renew_action()
	{
	    $db= DBLayer::get_instance();
		$id=$this->read_page_param(1);
		$from=$this->read_page_param(2);
		$types=$this->read_page_param(3);
		$statuss=$this->read_page_param(4);
		$featureds=$this->read_page_param(5);
		$categs=$this->read_page_param(6);
		$pg=$this->read_page_param(7);
		
		$pgnew=explode("-",$pg);
		if($pgnew[0] !="page")
		$pg="";
		
		
		if($pg=="")
		$pg="page-1";
		
		if($types =="")
		$types=-1;
		
		if($statuss =="")
		$statuss=-2;
		
		if($featureds =="")
		$featureds=-1;
		
		if($categs =="")
		$categs=0;
		
		
		if(!$this->get_item_exists($id))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('item/manage'),0);
			exit;
		}
		
		
		$expiry=Settings::get_instance()->read("ad_expiry");
		$time_arr=getdate(time());
		
		$result=$db->execute_query("select * from ".TABLE_PREFIX."items where id=?",array($id));
		$value=$result->fetch_assoc();
		
		$ex=$value['expiry_time'];
		$user=$value['user'];
		
				
		if($ex < time() && $value['status']==2)
		{
			$gmtime=gmmktime($time_arr['hours'],$time_arr['minutes'],$time_arr['seconds'],$time_arr['mon'],$time_arr['mday']+$expiry,$time_arr['year']);
			
			$result=$db->execute_query("UPDATE ".TABLE_PREFIX."items set home_listing=0,home_expiry=0,home_days=0,status=1,featured=0,no_of_days=0,featured_expiry=0,expiry_time=?,update_time=?,publish_time=? where id=?",array($gmtime,time(),time(),$id));
			
			$db->execute_query("DELETE FROM ".TABLE_PREFIX."notification WHERE itemid=?",array($id));
		
			if($from ==1)
			$this->flash($this->get_message('item renewed'), $this->make_url('user/profile/'.$user."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg));
			else if($from ==2)
			$this->flash($this->get_message('item renewed'), $this->make_url('item/preview/'.$id));
			else
			$this->flash($this->get_message('item renewed'), $this->make_url('item/manage'."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg));
		}
		else
		{
			if($from ==1)
			$this->flash($this->get_message('listing is not expired'), $this->make_url('user/profile/'.$user."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);
		    else if($from ==2)
		    $this->flash($this->get_message('listing is not expired'), $this->make_url('item/preview/'.$id));
		    else
			$this->flash($this->get_message('listing is not expired'), $this->make_url('item/manage'."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);
		}
		exit;
	}
	
	
	
	function delete_action()
	{
		$id=$this->read_page_param(1);
		$from=$this->read_page_param(2);
		
		$types=$this->read_page_param(3);
		$statuss=$this->read_page_param(4);
		$featureds=$this->read_page_param(5);
		$categs=$this->read_page_param(6);
		
		
		$pg=$this->read_page_param(7);
		
		
		
		$pgnew=explode("-",$pg);
		if($pgnew[0] !="page")
		$pg="";
		
		if($pg=="")
		$pg="page-1";
		
		if($types =="")
		$types=-1;
		
		if($statuss =="")
		$statuss=-2;
		
		if($featureds =="")
		$featureds=-1;
		
		if($categs =="")
		$categs=0;
		
		
		
		
		$db= DBLayer::get_instance();
		
		
		if(!$this->get_item_exists($id))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('item/manage'),0);
			exit;
		}
	
		
		
		if($id <=10  && DEMO_MODE==TRUE)
		{
		
			if($from ==1)
			{
				$uids=$db->read_single_column("select user from ".TABLE_PREFIX."items where id=?",array($id));
				$this->flash($this->get_message('demo mode'), $this->make_url('user/profile/'.$uids."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);
			}
			else
				$this->flash($this->get_message('demo mode'), $this->make_url('item/manage'."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);
		
		
			exit;
		}
		
		
		
		
		
		$uids=$db->read_single_column("select user from ".TABLE_PREFIX."items where id=?",array($id));
		
				
		$itemcategory=$this->get_item_category($id);
		$lastpid=intval($this->get_last_parent_id($itemcategory));
		
		$db->execute_query("DELETE FROM ".TABLE_PREFIX."customfields_".$lastpid." WHERE itemid=?",array($id));
		$db->execute_query("DELETE FROM ".TABLE_PREFIX."customfields_0 WHERE itemid=?",array($id));
		
		$db->execute_query("DELETE FROM ".TABLE_PREFIX."notification WHERE itemid=?",array($id));
		
		$res=$db->execute_query("DELETE FROM ".TABLE_PREFIX."items WHERE id=?",array($id));
	
		$mydir = '../'.DATA_DIR.DIRECTORY_SEPARATOR.$id.DIRECTORY_SEPARATOR;
		$d = dir($mydir);
		if($d)
		{
			while($entry = $d->read())
			{
				if ($entry!= "." && $entry!= "..")
				{
					unlink('../'.DATA_DIR.DIRECTORY_SEPARATOR.$id.DIRECTORY_SEPARATOR.$entry);
				}
			}
			$d->close();
			rmdir($mydir);
		}
		
		
		
		

		
		if($from ==1)
		$this->flash($this->get_message('item deleted'), $this->make_url('user/profile/'.$uids."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg));
		else
		$this->flash($this->get_message('item deleted'), $this->make_url('item/manage'."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg));
		
		exit;
		
		
	}
	function load_custom_view_action()
	{
	    $db= DBLayer::get_instance();
		$itemid=$this->read_page_param(1);
		
	
	
	
		$cudata="";
	
	
		$cat_id=$db->read_single_column("select category from ".TABLE_PREFIX."items where id='$itemid'");
	
	
		$cudata=$this->display_cfield($cat_id);
		$cudata=$cudata.$cat_id;
	
	
		$astr="";
		$cudata_arr=explode("_",$cudata);
	
		if(count($cudata_arr) >0)
		{
			for($k=0;$k< count($cudata_arr); $k++)
			{
			$astr.=" ,$cudata_arr[$k] ";
	}
	}
	
	
	if($cat_id >0)
	$lastpid=$this->get_last_parent_id($cat_id);
	else
	$lastpid=0;
	
	$customfields=DBLayer::get_instance()->execute_query(
			"SELECT cf.id as cfid,cf.field_name as fname,cf.groupid as grpid,cf.cat_id as ccat,cg.name,cf.sub_field,cf.type FROM ".TABLE_PREFIX."customfields cf
			LEFT OUTER JOIN ".TABLE_PREFIX."customgroups cg
			ON cf.groupid=cg.id
			WHERE (cat_id=0 or cat_id IN (0 ".$astr." )) AND cf.status=1 AND (cg.status =1 OR cg.status IS NULL) ORDER BY cf.cat_id,cf.priority,cg.priority ASC"
	);
	
	
	$this->set_result("res",$customfields);
	
	
	$this->set_variable("itemid",$itemid);
	
	$this->set_variable("catid",$cat_id);
	
	
	
	
	//	die;
	}
	
	
	function delete_video_action()
	{
	    $db= DBLayer::get_instance();
		$itemid=$this->read_page_param(1);
		$vid=$this->read_page_param(2);
		
		if(!$this->get_item_exists($itemid))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('item/manage'),0);
			exit;
		}
		
		
		if($vid ==2)
		$db->execute_query("update ".TABLE_PREFIX."items set video2='' where id=?",array($itemid));
		else if($vid ==1)
		{
			$video2=$db->read_single_column("SELECT video2 FROM ".TABLE_PREFIX."items WHERE id=?",array($itemid));
			
			$db->execute_query("update ".TABLE_PREFIX."items set video1=?,video2='' where id=?",array($video2,$itemid));
		}
		
		$this->flash($this->get_message('video deleted successfully'),$this->make_url("item/manage_image/".$itemid));
		exit;
	}
	
	function delete_image_action()
	{
	    $db= DBLayer::get_instance();
		$itemid=$this->read_page_param(1);
		$imageid=$this->read_page_param(2);
	
	
		if(!$this->get_item_exists($itemid))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('item/manage'),0);
			exit;
		}

		
		if($imageid !="a")
		{
			$spold_image=$db->read_single_column("select image from ".TABLE_PREFIX."images where id=? and itemid=?",array($imageid,$itemid));
	
			$sql=$db->execute_query("delete from ".TABLE_PREFIX."images where id=? and itemid=?",array($imageid,$itemid));
	
			unlink("../".DATA_DIR.DIRECTORY_SEPARATOR.$itemid.DIRECTORY_SEPARATOR.$spold_image);
			unlink("../".DATA_DIR.DIRECTORY_SEPARATOR.$itemid.DIRECTORY_SEPARATOR."t_".$spold_image);
		}
		else
		{
	
			$spold_image=$db->read_single_column("select image from ".TABLE_PREFIX."items where id=?",array($itemid));
	
	
			$spimagecount=$db->read_single_column("select count(id) from ".TABLE_PREFIX."images where itemid=?",array($itemid));
	
			if($spimagecount >0)
			{
				$newimageid=$db->read_single_column("select id from ".TABLE_PREFIX."images where itemid=? limit 0,1",array($itemid));
				$newimage=$db->read_single_column("select image from ".TABLE_PREFIX."images where itemid=? limit 0,1",array($itemid));
	
	
	
				$sql=$db->execute_query("update ".TABLE_PREFIX."items set image=? where id=?",array($newimage,$itemid));
	
	
	
				$sqldel=$db->execute_query("delete from ".TABLE_PREFIX."images where id=? and itemid=?",array($newimageid,$itemid));
	
			}
			else
			{
				$sql=$db->execute_query("update ".TABLE_PREFIX."items set image=? where id=?",array("",$itemid));
			}
	
			unlink("../".DATA_DIR.DIRECTORY_SEPARATOR.$itemid.DIRECTORY_SEPARATOR.$spold_image);
			unlink("../".DATA_DIR.DIRECTORY_SEPARATOR.$itemid.DIRECTORY_SEPARATOR."t_".$spold_image);
	
		}
	
		$this->flash($this->get_message('image deleted successfully'),$this->make_url("item/manage_image/".$itemid));
		exit;
	
	}
	function remove_premium_action()
	{
			$itemid=$this->read_page_param(1);
			$operation=$this->read_page_param(2);
			$from=$this->read_page_param(3);
		    $types=$this->read_page_param(4);
			$statuss=$this->read_page_param(5);
			$featureds=$this->read_page_param(6);
			$categs=$this->read_page_param(7);
			$pg=$this->read_page_param(8);
			
			$home=0;
			$planid=0;
			if($home =="")
			$home=0;
			
			
			
			$pgnew=explode("-",$pg);
			if($pgnew[0] !="page")
			$pg="";
			
			
			if($pg=="")
			$pg="page-1";
			
			
			$db=DBLayer::get_instance();
			
			
			
			
			if(!$this->get_item_exists($itemid))
			{
				$this->flash($this->get_message('invalid id'), $this->make_url('item/manage'),0);
				exit;
			}
			
			$uids=$db->read_single_column("select user from ".TABLE_PREFIX."items where id=?",array($itemid));

		
		if(Settings::get_instance()->read('enable_premium_listing') ==0 && Settings::get_instance()->read('home_page_listing') ==0)
		{
			if($from ==1)
			$this->flash($this->get_message('invalid operation'), $this->make_url('user/profile/'.$uids."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);
			else if($from ==2)
			$this->flash($this->get_message('invalid operation'), $this->make_url('item/preview/'.$itemid),0);
			else
			$this->flash($this->get_message('invalid operation'), $this->make_url('item/manage'."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg),0);
			
			exit;
		}
				
		if($operation ==1)
		{
			$db->execute_query("UPDATE ".TABLE_PREFIX."items SET featured=0,featured_expiry=0 WHERE id=?",array($itemid));
	
			if($from ==2)
			$this->flash($this->get_message('premium listing removed'), $this->make_url('item/preview/'.$itemid));
			else
			$this->flash($this->get_message('premium listing removed'), $this->make_url("item/premium/".$itemid."/".$from."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg));
		}
		else if($operation==2)
		{
			$db->execute_query("UPDATE ".TABLE_PREFIX."items SET home_listing=0,home_expiry=0 WHERE id=?",array($itemid));
			
			if($from ==2)
			$this->flash($this->get_message('home listing disabled'), $this->make_url('item/preview/'.$itemid));
			else
			$this->flash($this->get_message('home listing disabled'), $this->make_url("item/premium/".$itemid."/".$from."/".$types."/".$statuss."/".$featureds."/".$categs."/".$pg));
		}

		exit;
	}
	
	
	function reviews_action()
	{
	
		$this->set_title($this->get_label('manage reviews'));
	
		$listing_id=$this->read_page_param(1);
		$this->set_variable('listing_id', $listing_id);
	
		$sql="select * from ".TABLE_PREFIX."product_rating where listing_id=? order by time desc";
		$pagination = new Pagination($sql,array($listing_id));
		$res=$pagination->get_result();
		$this->set_result("res",$res);
		$this->set_variable("pagination",$pagination->links(),0);
	
	}
	
	
	function activate_review_action()
	{
		$id=$this->read_page_param(1);
		$listing_id=$this->read_page_param(2);
	
		$db=DBLayer::get_instance();
		$db->execute_query("update ".TABLE_PREFIX."product_rating set status=1 where id=?",array( $id));
		$this->flash($this->get_message('item activated'), $this->make_url('item/reviews/'.$listing_id));
	
		exit;
	
	}
	
	function block_review_action()
	{
		$id=$this->read_page_param(1);
		$listing_id=$this->read_page_param(2);
	
		$db=DBLayer::get_instance();
		$db->execute_query("update ".TABLE_PREFIX."product_rating set status=0 where id=?",array( $id));
		$this->flash($this->get_message('item blocked'), $this->make_url('item/reviews/'.$listing_id));
	
		exit;
	
	}
	function delete_review_action()
	{
		$id=$this->read_page_param(1);
		$listing_id=$this->read_page_param(2);
		$db= DBLayer::get_instance();
		$res=$db->execute_query("delete from ".TABLE_PREFIX."product_rating where id=?",array($id));
	
	
	
		$this->flash($this->get_message('review deleted'), $this->make_url('item/reviews/'.$listing_id));
		exit;
	}
	
	function bulk_operations_action()
	{
	    $db= DBLayer::get_instance();
	    $this->disable_notice_area();
	    $operation=intval($this->read_post_param('operationhidden'));
	    $ids=explode(',',$this->read_post_param('idshidden'));
	    $filterhidden_post=$this->read_post_param('filterhidden');
	    $filterhidden=explode('/', $filterhidden_post);
	    $block_success=0;
	    $enable_success=0;
	    $delete_success=0;
	    $engine_name=Settings::get_instance()->read('engine_name');
	    $types=$filterhidden[0];
	    $statuss=$filterhidden[1];
	    $featureds=$filterhidden[2];
	    $categs=$filterhidden[3];
	    $pg=$filterhidden[4];
	    $pgnew=explode("-",$pg);
	    if($pgnew[0] !="page")
	        $pg="";
	        if($pg=="")
	            $pg="page-1";
	            if($types =="")
	                $types=-1;
	                if($statuss =="")
	                    $statuss=-2;
	                    if($featureds =="")
	                        $featureds=-1;
	                        if($categs =="")
	                            $categs=0;
	    if($operation ==0 && count($ids) > 0)
	    {
	        $res1=$db->execute_query("select * from ".TABLE_PREFIX."emailtemplates where id=2");
	        $row1=$res1->fetch_assoc();
	        foreach($ids as $key=>$id)
	        {
	
	            $res=$db->execute_query("select * from ".TABLE_PREFIX."items where id=? and status=1",array($id));
	            if($res->num_records>0)
	            {
	                $db->execute_query("update ".TABLE_PREFIX."items set status=0 where id=?",array($id));
	                $row=$res->fetch_assoc();
	                $details=$db->execute_query("select email,locale from ".TABLE_PREFIX."users where id=?",array($row['user']));
	                if($details->num_records > 0)
	                {
    	                $value=$details->fetch_assoc();
    	                $sub=$row1['sub'];
    	                $body=$row1['body'];
    	                if(isset($row1[$value['locale'].'_sub']) && $row1[$value['locale'].'_sub']!='')
    	                $sub=$row1[$value['locale'].'_sub'];
    	                if(isset($row1[$value['locale'].'_body']) && $row1[$value['locale'].'_body']!='')
    	                $sub=$row1[$value['locale'].'_body'];
    	                $sub=str_ireplace("{ENGINE}",$engine_name,$sub);
    	                $sub=str_ireplace("{TITLE}",$row['title'],$sub);
    	                $body=str_ireplace("{ENGINE}",$engine_name,$body);
    	                $body=str_ireplace("{TITLE}",$row['title'],$body);
    	                UtilityHelper::send_mail($value['email'],$sub, $body);
    	                $block_success=$block_success+1;
	                }
	            }
	        }
	    }
	    else if($operation == 1)
	    {
	        // activate
	        $res1=$db->execute_query("select * from ".TABLE_PREFIX."emailtemplates where id=1");
	        $row1=$res1->fetch_assoc();
	        foreach($ids as $key=>$id)
	        {
	            $res=$db->execute_query("select * from ".TABLE_PREFIX."items where status=0 AND id=?",array($id));
	            if($res->get_num_records() > 0)
	            {
	                $row=$res->fetch_assoc();
	                $premiumad=$row['featured'];
	                $homead=$row['home_listing'];
	                $home_expiry=$row['home_expiry'];
	                $status=$row['status'];
	                $expr=$row['expiry_time'];
	                $paid_status=$row['paid_status'];
	                $premium_expiry=$row['no_of_days'];
	                $prexpr=$row['featured_expiry'];
	                $paid_days=$row['paid_days'];
	                $home_days=$row['home_days'];
	                $time_arr=getdate(time());
	                $expiry=Settings::get_instance()->read("ad_expiry");
	                $listing_mode=Settings::get_instance()->read('system_listing_mode');
	                $gmtime=gmmktime($time_arr['hours'],$time_arr['minutes'],$time_arr['seconds'],$time_arr['mon'],$time_arr['mday']+$expiry,$time_arr['year']);
	                $premium_gmtime=gmmktime($time_arr['hours'],$time_arr['minutes'],$time_arr['seconds'],$time_arr['mon'],$time_arr['mday']+$premium_expiry,$time_arr['year']);
	                    if($premiumad ==0)
	                    {
	                        $msg=$this->get_label('no');
	                        if($expr >0)	//active=>block=>activate
	                        {
	                            $db->execute_query("update ".TABLE_PREFIX."items set status=1,update_time=? where id=?",array(time(),$id));
	                            $db->execute_query("update ".TABLE_PREFIX."items set publish_time=? where id=? AND publish_time=0",array(time(),$id));
	                        }
	                        else // pending=>block=>activate
	                            $db->execute_query("update ".TABLE_PREFIX."items set status=1,update_time=?,expiry_time=?,publish_time=? where id=?",array(time(),$gmtime,time(),$id));
	                    }
	                    else if($premiumad ==1)
	                    {
	                        $msg=$this->get_label('yes');
	                        if($gmtime < $premium_gmtime && $paid_status ==0)
	                            $gmtime=$premium_gmtime;
	                            if($premium_expiry ==0)//active=>block=>activate
	                            {
	                                if($expr >0)
	                                {
	                                    $db->execute_query("update ".TABLE_PREFIX."items set status=1,update_time=? where id=?",array(time(),$id));
	                                    $db->execute_query("update ".TABLE_PREFIX."items set publish_time=? where id=? AND publish_time=0",array(time(),$id));
	                                }
	                                else
	                                    $db->execute_query("update ".TABLE_PREFIX."items set status=1,publish_time=?,update_time=?,expiry_time=? where id=?",array(time(),time(),$gmtime,$id));
	                            }
	                            else // pending=>block=>activate
	                                $db->execute_query("update ".TABLE_PREFIX."items set status=1,publish_time=?,update_time=?,expiry_time=?,featured_expiry=? where id=?",array(time(),time(),$gmtime,$premium_gmtime,$id));
	                    }
	                    if($paid_status==1)
	                    {
	                        if($paid_days >0)
	                        {
	                            $current_new_expiry=$db->read_single_column("select expiry_time from ".TABLE_PREFIX."items where id=?",array($id));
	                            if($current_new_expiry > time())
	                            {
	                                $time_arr1=getdate($current_new_expiry);
	                                $current_new_expiry=gmmktime($time_arr1['hours'],$time_arr1['minutes'],$time_arr1['seconds'],$time_arr1['mon'],$time_arr1['mday']+$paid_days,$time_arr1['year']);
	                            }
	                            else
	                                $current_new_expiry=gmmktime($time_arr['hours'],$time_arr['minutes'],$time_arr['seconds'],$time_arr['mon'],$time_arr['mday']+$paid_days,$time_arr['year']);
	                                $db->execute_query("update ".TABLE_PREFIX."items set expiry_time=?,paid_days=0 where id=?",array($current_new_expiry,$home_expiry,$id));
	                        }
	                    }
	                    if($homead ==1 && Settings::get_instance()->read('home_page_listing') ==1)
	                    {
	                        if($home_days >0)
	                        {
	                            $home_expiry=gmmktime($time_arr['hours'],$time_arr['minutes'],$time_arr['seconds'],$time_arr['mon'],$time_arr['mday']+$home_days,$time_arr['year']);
	                            $current_new_expiry=$db->read_single_column("select expiry_time from ".TABLE_PREFIX."items where id=?",array($id));
	                            if($current_new_expiry < $home_expiry && $paid_status ==0)
	                                $current_new_expiry=$home_expiry;
	                                $db->execute_query("update ".TABLE_PREFIX."items set expiry_time=?,home_expiry=? where id=? AND home_listing=1",array($current_new_expiry,$home_expiry,$id));
	                        }
	                    }
	                    $db->execute_query("update ".TABLE_PREFIX."items set home_days=0,no_of_days=0 where id=?",array($id));
	                    $details=$db->execute_query("select email,locale from ".TABLE_PREFIX."users where id=?",array($row['user']));
	                    $value=$details->fetch_assoc();
	                    $sub=$row1['sub'];
	                    $body=$row1['body'];
	                    if(isset($row1[$value['locale'].'_sub']) && $row1[$value['locale'].'_sub']!='')
	                        $sub=$row1[$value['locale'].'_sub'];
	                        if(isset($row1[$value['locale'].'_body']) && $row1[$value['locale'].'_body']!='')
	                            $sub=$row1[$value['locale'].'_body'];
	                            $sub=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$sub);
	                            $sub=str_ireplace("{TITLE}",$row['title'],$sub);
	                            $body=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$body);
	                            $body=str_ireplace("{TITLE}",$row['title'],$body);
	                            $body=str_ireplace("{PREMIUM}",$msg,$body);
	                            UtilityHelper::send_mail($value['email'],$sub, $body);
	                            $enable_success=$enable_success+1;
	                }
	        }
	    }
	    else if($operation == 2)
	    {
	        foreach($ids as $key=>$id)
	        {
                $uids=$db->read_single_column("select user from ".TABLE_PREFIX."items where id=?",array($id));
                if($uids !="")
                {
                $itemcategory=$this->get_item_category($id);
                $lastpid=intval($this->get_last_parent_id($itemcategory));
                $db->execute_query("DELETE FROM ".TABLE_PREFIX."customfields_".$lastpid." WHERE itemid=?",array($id));
                $db->execute_query("DELETE FROM ".TABLE_PREFIX."customfields_0 WHERE itemid=?",array($id));
                $db->execute_query("DELETE FROM ".TABLE_PREFIX."notification WHERE itemid=?",array($id));
                $res=$db->execute_query("DELETE FROM ".TABLE_PREFIX."items WHERE id=?",array($id));
                $mydir = '../'.DATA_DIR.DIRECTORY_SEPARATOR.$id.DIRECTORY_SEPARATOR;
                $d = dir($mydir);
                if($d)
                {
                    while($entry = $d->read())
                    {
                        if ($entry!= "." && $entry!= "..")
                        {
                            unlink('../'.DATA_DIR.DIRECTORY_SEPARATOR.$id.DIRECTORY_SEPARATOR.$entry);
                        }
                    }
                    $d->close();
                    rmdir($mydir);
                }
                $delete_success=$delete_success+1;
                }
	        }
	    }
	    $msg='';
	    if($block_success > 0)
	    {
	        $msg=$this->get_message('items has blocked',array('x'=>$block_success));
	    }
	    else if($enable_success > 0)
	        {
	            $msg=$this->get_message('items has activated',array('x'=>$enable_success));
	        }
	    else if($delete_success > 0)
	    {
	        $msg=$this->get_message('items has deleted',array('x'=>$delete_success));
	    }
	    else {
	        $msg=$this->get_message('no operation');
	    }
	    $types=$filterhidden[0];
	    $statuss=$filterhidden[1];
	    $featureds=$filterhidden[2];
	    $categs=$filterhidden[3];
	    $pg=$filterhidden[4];
	    $this->flash($msg, $this->make_url('item/manage/'.$types.'/'.$statuss.'/'.$featureds.'/'.$categs.''.$pg));
	}
};
?>
