<?php
include_once COMMON_DIR_PATH.'helpers'.DS."login-helper.php";
include_once COMMON_DIR_PATH.'helpers'.DS."utility-helper.php";

class LocaleController extends AppController
{
	function before_execute()
	{
		parent::before_execute();
		
		if(!(LoginHelper::validate_admin_login()))
		{
			$this->flash($this->get_message('login failed'), $this->make_base_url('index/index',ADMIN_DIR),0);
		}
	}
	
	function status_action()
	{
	    $db= DBLayer::get_instance();
		$id=intval($this->read_page_param(1));
		$status=intval($this->read_page_param(2));
		
		if(!$this->get_locale_exists($id))
		{
			$this->flash($this->get_message('invalid id'),$this->make_base_url('locale/manage',ADMIN_DIR),0);
			exit;
		}
		
		
		if($status >1)
		$status=0;
		
		$db->execute_query("UPDATE ".TABLE_PREFIX."locale SET status=? WHERE id=?",array($status,$id));
		
		
		if($status ==0)
		{
			$default_local_id=$db->read_single_column("select id from ".TABLE_PREFIX."locale where name=?",array(DEFAULT_LOCALE));
			$db->execute_query("update ".TABLE_PREFIX."users set locale=? where locale=?",array($default_local_id,$id));
		}
		
		
		
		$this->flash($this->get_message('locale status updated'),$this->make_base_url('locale/manage',ADMIN_DIR));
		exit;
	}
	
	function change_language_action()
	{
	    $db= DBLayer::get_instance();
		$this->disable_notice_area();
		$language=$this->read_page_param(1);
	
		$id=$db->read_single_column("SELECT id FROM ".TABLE_PREFIX."locale WHERE name=?",array($language));
	
		if($id >0)
		$this->set_locale($language);
		if(LoginHelper::validate_user_login())
		{
			$user=$this->read_cookie_param(COOKIE_LOGINID);
			$db->execute_query("update ".TABLE_PREFIX."users set locale=? where id=? ",array($id,$user));
			 	  
		}
		exit;
	}
	
	function add_action()
	{
		$name="";
		$desc="";
		$direction=0;
		
		
		
		if($_POST)
		{
			$name=$this->read_post_param('name');
			$desc=$this->read_post_param('desc');
			$direction=$this->read_post_param('direction');
	
			if($name=="" || $desc=="")
			{
				$this->set_notice("mandatory");
			}
			else
			{
			    $db= DBLayer::get_instance();
				$count=$db->read_single_column("select count(id) from ".TABLE_PREFIX."locale where name=?",array($name));
				if($count >0)
				{
					$this->set_notice("locale exists");
				}
				else
				{
					$res=$db->execute_query("INSERT INTO ".TABLE_PREFIX."locale (`name`,`description`,`direction`) values (?,?,?)",array($name,$desc,$direction));
					$languageid=$res->get_last_id();
					

					$db->execute_query("ALTER TABLE ".TABLE_PREFIX."countries ADD `".$languageid."_cname` VARCHAR(50) NOT NULL default ''");
					$db->execute_query("ALTER TABLE ".TABLE_PREFIX."states ADD `".$languageid."_sname` VARCHAR(50) NOT NULL default ''");
					$db->execute_query("ALTER TABLE ".TABLE_PREFIX."cities ADD `".$languageid."_city` VARCHAR(50) NOT NULL default ''");
					$db->execute_query("ALTER TABLE ".TABLE_PREFIX."customgroups ADD `".$languageid."_group_name` VARCHAR(80) NOT NULL default ''");
					$db->execute_query("ALTER TABLE ".TABLE_PREFIX."customfields ADD (`".$languageid."_field_name` VARCHAR(80) NOT NULL default '',`".$languageid."_sub_name` VARCHAR(80) NOT NULL default '')");
					$db->execute_query("ALTER TABLE ".TABLE_PREFIX."categories ADD (`".$languageid."_category_name` VARCHAR(255) NOT NULL default '',`".$languageid."_keyword` LONGTEXT,`".$languageid."_description` LONGTEXT)");

					
					$db->execute_query("ALTER TABLE ".TABLE_PREFIX."meta ADD (`".$languageid."_keyword` LONGTEXT,`".$languageid."_description` LONGTEXT)");
					$db->execute_query("ALTER TABLE ".TABLE_PREFIX."emailtemplates ADD (`".$languageid."_sub` VARCHAR(255) NOT NULL default '',`".$languageid."_body` LONGTEXT)");
					$db->execute_query("ALTER TABLE ".TABLE_PREFIX."aboutus ADD (`".$languageid."_description` LONGTEXT)");
					$db->execute_query("ALTER TABLE ".TABLE_PREFIX."terms ADD (`".$languageid."_description` LONGTEXT)");
										
					
					$db->execute_query("ALTER TABLE ".TABLE_PREFIX."custom_pages ADD (`".$languageid."_name` VARCHAR(255) NOT NULL default '',`".$languageid."_content` LONGTEXT,`".$languageid."_title` VARCHAR(255) NOT NULL default '',`".$languageid."_meta_keyword` LONGTEXT,`".$languageid."_meta_description` LONGTEXT)");
 
					
					
					$this->flash($this->get_message('locale added'),$this->make_base_url('locale/manage',ADMIN_DIR));
					exit;
				}
			}
		}
		$this->set_variable("name",$name);
		$this->set_variable("desc",$desc);
		$this->set_variable("direction",$direction);
		
		
	}
	
	function manage_action()
	{
		$this->set_title($this->get_label('manage locale'));
	
		$db= DBLayer::get_instance();
	
	
		$res=$db->execute_query("select * from ".TABLE_PREFIX."locale order by id desc");
		$this->set_result("res",$res);
	}
	
	
	function edit_action()
	{
		$this->set_title($this->get_label('edit locale'));
	
		$db= DBLayer::get_instance();
	
		if($_POST)
		$id=intval($this->read_post_param('id'));
		else
		$id=intval($this->read_page_param(1));
	
	
		
	
		if(!$this->get_locale_exists($id))
		{
			$this->flash($this->get_message('invalid id'),$this->make_base_url('locale/manage',ADMIN_DIR),0);
			exit;
		}
	
	
		$name=$db->read_single_column("select name from ".TABLE_PREFIX."locale where id=?", array($id));
		if($name == DEFAULT_LOCALE)
		{
			$this->flash($this->get_message('locale default manipulation'),$this->make_base_url('locale/manage',ADMIN_DIR),0);
			exit;
		}
	
	
		if($_POST)
		{
			$name=$this->read_post_param('name');
			$desc=$this->read_post_param('desc');
			$direction=$this->read_post_param('direction');
	
			if($id==0 || $name=="" || $desc=="")
			{
				$this->set_notice("mandatory");
			}
			else
			{
				$count=$db->read_single_column("select count(id) from ".TABLE_PREFIX."locale where name=? and id <> ?",array($name,$id));
				if($count >0)
				{
					$this->set_notice("locale exists");
				}
				else
				{
					$res=$db->execute_query("update ".TABLE_PREFIX."locale set name=?,description=?,direction=? where id=?",array($name,$desc,$direction,$id));
	
					$this->flash($this->get_message('locale edited'),$this->make_base_url('locale/manage',ADMIN_DIR));
					exit;
				}
			}
		}
		else
		{
			$res=$db->execute_query("select * from ".TABLE_PREFIX."locale where id=?",array($id));
			$row=$res->fetch_assoc();
	
			$id=$row['id'];
			$name=$row['name'];
			$desc=$row['description'];
			$direction=$row['direction'];
		}
	
		$this->set_variable("id",$id);
		$this->set_variable("name",$name);
		$this->set_variable("desc",$desc);
		$this->set_variable("direction",$direction);
		
	}
	
	function delete_action()
	{
	    $db= DBLayer::get_instance();
	
		$id=intval($this->read_page_param(1));
	
		if(!$this->get_locale_exists($id))
		{
			$this->flash($this->get_message('invalid id'),$this->make_base_url('locale/manage',ADMIN_DIR),0);
			exit;
		}
	
		$name=$db->read_single_column("select name from ".TABLE_PREFIX."locale where id=?",array($id));
		if($name==DEFAULT_LOCALE)
		{
			$this->flash($this->get_message('locale default manipulation'),$this->make_base_url('locale/manage',ADMIN_DIR),0);
			exit;
		}
		else
		{
			$res=$db->execute_query("delete from ".TABLE_PREFIX."locale where id=?",array($id));
			$default_local_id=$db->read_single_column("select id from ".TABLE_PREFIX."locale where name=?",array(DEFAULT_LOCALE));
			
			$db->execute_query("update ".TABLE_PREFIX."users set locale=? where locale=?",array($default_local_id,$id));
		
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."countries DROP `".$id."_cname`");
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."states DROP `".$id."_sname`");
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."cities DROP `".$id."_city`");
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."customgroups DROP `".$id."_group_name`");
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."customfields DROP `".$id."_field_name`");
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."customfields DROP `".$id."_sub_name`");
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."categories DROP `".$id."_category_name`");
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."categories DROP `".$id."_description`");
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."categories DROP `".$id."_keyword`");
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."meta DROP `".$id."_description`");
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."meta DROP `".$id."_keyword`");
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."emailtemplates DROP `".$id."_sub`");
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."emailtemplates DROP `".$id."_body`");
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."aboutus DROP `".$id."_description`");
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."terms DROP `".$id."_description`");
						
			
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."custom_pages DROP `".$id."_name`"); 
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."custom_pages DROP `".$id."_content`"); 
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."custom_pages DROP `".$id."_title`"); 
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."custom_pages DROP `".$id."_meta_keyword`"); 
			$db->execute_query("ALTER TABLE ".TABLE_PREFIX."custom_pages DROP `".$id."_meta_description`"); 
			 
			
			
	
			$this->flash($this->get_message('locale deleted'),$this->make_base_url('locale/manage',ADMIN_DIR));
			exit;
		}
	}
	
	
		

	
};
