<?php
include_once COMMON_DIR_PATH.DS.'helpers'.DS."login-helper.php";
class LocationController extends AppController
{
	function before_execute()
	{
		if(LoginHelper::validate_admin_login()==0)
		{
			$this->flash($this->get_message('login failed'), $this->make_url('index/index'),0);
		}
	}
	
	
	
	function manage_regions_action()
	{
		$this->set_title($this->get_label('manage regions'));
		
		$language_enabled=Settings::get_instance()->read('language_enabled');
		
	
		$ccode=$this->read_page_param(1);
		$this->set_variable('ccode',$ccode);
	
		$db= DBLayer::get_instance();
		$defcountry=$db->execute_query("select code from ".TABLE_PREFIX."specific_countries");
	
		$defstr="";
		$a=0;
		$defcountry_count=$defcountry->get_num_records();
		while($defcountry_row=$defcountry->fetch_array())
		{
			$a=$a+1;
			$defstr.="'".$defcountry_row['code']."'";
	
			if($a !=$defcountry_count)
			{
				$defstr.=',';
			}
		}
	
	
		$qstr="";
		if($defstr !="")
		{
			$qstr="where ccode IN (".$defstr.") ";
		}
	
		$res=$db->execute_query("select * from ".TABLE_PREFIX."countries ".$qstr." order by cname");
		$this->set_result('res', $res);
		
		if($language_enabled ==1){
		$localedata=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."locale WHERE status=1 OR name='".DEFAULT_LOCALE."'");
		$this->set_result('localedata',$localedata);
		}
	}
	function load_regions_action()
	{
		$this->disable_notice_area();
		$db= DBLayer::get_instance();
		$country=$this->read_page_param(1);
		$asc=$this->read_page_param(2);
	
			$language_enabled=Settings::get_instance()->read('language_enabled');
		
		$data="";
	
		if($asc=="" || $asc==0)
		$data=" order by sname DESC";
		else if($asc==1)
		$data=" order by sname ASC";
	
	
		$res=$db->execute_query("select * from ".TABLE_PREFIX."states where ccode=?".$data." ",array($country));
		$this->set_result("res",$res);
	
		$this->set_variable("ctr",$country);
		$this->set_variable("asc",$asc);
		
		if($language_enabled ==1)
		{
		$localedata=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."locale WHERE status=1 OR name='".DEFAULT_LOCALE."'");
		$this->set_result('localedata',$localedata);
		}
	}
	
	function add_region_action()
	{
		$this->set_title($this->get_label('add region'));
		
		$language_enabled=Settings::get_instance()->read('language_enabled');
		
		if($_POST)
		{
		    $db= DBLayer::get_instance();
	
			$country=$this->read_post_param('country');
			$rname=$this->read_post_param('rname');
			$rcode=$this->read_post_param('rcode');
	
	
			if($language_enabled ==1){
			$localedata=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."locale WHERE status=1 OR name='".DEFAULT_LOCALE."'");
			$locale1='';
			$locale2=array();
			while($localerow=$localedata->fetch_assoc())
			{
				$submitvalue=trim($this->read_post_param($localerow['id'].'_sname'));
			
				$this->set_variable($localerow['id'].'_sname',$submitvalue);
			
				if($submitvalue !='')
				{
					if($locale1 !='')
					$locale1.=',';
			
					$locale1.=$localerow['id'].'_sname=?';
			
					$locale2[]=$submitvalue;
				}
			}
			}
			
			
	
	
			if($country=="" || $rname=="" || $rcode=="" || $rcode=="00" || $rcode=="0")
			{
				$this->flash($this->get_message('mandatory'), $this->make_url('location/manage_regions'),0);
				exit;
			}
			else
			{
				$already=$db->read_single_column("select count(id) from ".TABLE_PREFIX."states where ccode=? and (scode=? || sname=?)",array($country,$rcode,$rname));
				if($already >0)
				{
					$this->flash($this->get_message('already added region'), $this->make_url('location/manage_regions/').$country,0);
					exit;
				}
				else
				{
					$res=$db->execute_query("INSERT INTO ".TABLE_PREFIX."states (`scode` ,`sname`,`ccode`) values (?,?,?)",array($rcode,$rname,$country));
	
					
					$lid=$res->get_last_id();
					
					if($language_enabled ==1){
					if($locale1 !='' && count($locale2) >0)
					{
						$locale2[]=$lid;
						$db->execute_query("UPDATE ".TABLE_PREFIX."states SET ".$locale1." WHERE id=?",$locale2);
					}
					}
					
					
					$this->flash($this->get_message('region added'), $this->make_url('location/manage_regions/').$country);
					exit;
				}
			}
		}
		else
		{
			header("Location:".$this->make_url('location/manage_regions'));
			exit;
		}
	
	}
	function delete_region_action()
	{
	    $db= DBLayer::get_instance();
		$id=$this->read_page_param(1);
	
		$ccode=$db->read_single_column("select ccode from ".TABLE_PREFIX."states where id=?",array($id));
		$scode=$db->read_single_column("select scode from ".TABLE_PREFIX."states where id=?",array($id));
		
		
		
		if(DEMO_MODE)
		{
			$this->flash($this->get_message('demo mode'), $this->make_url('location/manage_regions/').$ccode,0);
			exit;
		}
		
	
		$count=$db->read_single_column("select count(id) from ".TABLE_PREFIX."cities where ccode=? and scode=?",array($ccode,$scode));
	
		if($count >0)
		{
			$this->flash($this->get_message('cities exists'), $this->make_url('location/manage_regions/').$ccode,0);
			exit;
		}
		else
		{
			$res=$db->execute_query("delete from ".TABLE_PREFIX."states where id=?",array($id));
			$this->flash($this->get_message('region deleted'), $this->make_url('location/manage_regions/').$ccode);
			exit;
		}
	}
	
	function update_region_action()
	{
		//sleep(2);
	    $db= DBLayer::get_instance();
		$this->disable_notice_area();
	
		$id=$this->read_post_param('id');
		$state=$this->read_post_param('state');
		$scode=$this->read_post_param('scode');
		$country=$this->read_post_param('country');
	
				$language_enabled=Settings::get_instance()->read('language_enabled');
		
		if($language_enabled ==1){
		$localedata=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."locale WHERE status=1 OR name='".DEFAULT_LOCALE."'");
		$locale1='';
		$locale2=array();
		while($localerow=$localedata->fetch_assoc())
		{
			$submitvalue=trim($this->read_post_param($localerow['id'].'_sname_edit_'.$id));
		
			if($locale1 !='')
			$locale1.=',';
		
			$locale1.=$localerow['id'].'_sname=?';
			$locale2[]=$submitvalue;
		}
		}
		
		
		
		if(DEMO_MODE)
		{
			echo 4;
			exit;
		}
		
	
	
		if($country=="" || $state=="" || $id=="" || $id <=0 || $scode=="" || $scode=="00" || $scode=="0")
		{
			echo 1;
			exit;
		}
		else
		{
			$already=$db->read_single_column("select count(id) from ".TABLE_PREFIX."states where ccode=? and (scode=? || sname=?) and id <>?",array($country,$scode,$state,$id));
	
			if($already >0)
			{
				echo 2;
				exit;
			}
			else
			{
				$res=$db->execute_query("UPDATE ".TABLE_PREFIX."states set scode=?,sname=? where ccode=? and id=?",array($scode,$state,$country,$id));
				
						if($language_enabled ==1){
				
				if($locale1 !='' && count($locale2) >0)
				{
					$locale2[]=$id;
					$db->execute_query("UPDATE ".TABLE_PREFIX."states SET ".$locale1." WHERE id=?",$locale2);
				}
						}
				
	
				echo 3;
				exit;
			}
		}
	}
	
	function load_state_action()
	{
		$this->disable_notice_area();
		$country=$this->read_page_param(1);
		$st=$this->read_page_param(2);
	
		$states=DBLayer::get_instance()->execute_query("select scode,sname from ".TABLE_PREFIX."states where ccode=? order by sname",array($country));
		$ret='';
	
		$ret.='<option value="00">'.$this->get_label("select state").'</option>';
	
		while($state=$states->fetch_row())
		{
			if($state[0]==$st)
				$ret.='<option value="'.$state[0].'" selected>'.$state[1].'</option>';
			else
				$ret.='<option value="'.$state[0].'">'.$state[1].'</option>';
		}
		echo $ret;die;
	}
	
	
	
	

	function manage_action()
	{
		$this->set_title($this->get_label('manage location'));
		
				$language_enabled=Settings::get_instance()->read('language_enabled');
		
		
		$ccode=$this->read_page_param(1);
		$scode=$this->read_page_param(2);
		$this->set_variable('ccode',$ccode);
		$this->set_variable('scode',$scode);
		
		$db= DBLayer::get_instance();
		
		$defcountry=$db->execute_query("select code from ".TABLE_PREFIX."specific_countries");
		
		$defstr="";
		$a=0;
		$defcountry_count=$defcountry->get_num_records();
		while($defcountry_row=$defcountry->fetch_array())
		{
			$a=$a+1;
			$defstr.="'".$defcountry_row['code']."'";
			
			if($a !=$defcountry_count)
			{
				$defstr.=',';
			}
		}
		
		
		$qstr="";
		if($defstr !="")
		{
			$qstr="where ccode IN (".$defstr.") ";
		}
		
		$res=$db->execute_query("select * from ".TABLE_PREFIX."countries ".$qstr." order by cname");
		$this->set_result('res', $res);
		
		
		if($language_enabled ==1)
		{
		$localedata=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."locale WHERE status=1 OR name='".DEFAULT_LOCALE."'");
		$this->set_result('localedata',$localedata);
		}
	}
	
	
	
	

	function load_cities_action()
	{
		$this->disable_notice_area();
		$db= DBLayer::get_instance();
		$country=$this->read_page_param(1);
		$state=$this->read_page_param(2);
		$asc=$this->read_page_param(3);
		
		$language_enabled=Settings::get_instance()->read('language_enabled');
		
		if($state =="")
		$state="00";
		
		
		$data="";
		
		if($asc=="" || $asc==0)
	  	$data=" order by city DESC";
		else if($asc==1)
	  	$data=" order by city ASC";

	
		$res=$db->execute_query("select * from ".TABLE_PREFIX."cities where ccode=? and scode=?".$data,array($country,$state));
		$this->set_result("res",$res);
		
	    $this->set_variable("ctr",$country);
	    $this->set_variable("state",$state);
	    $this->set_variable("asc",$asc);
	    
	    
	    if($language_enabled ==1){
	    $localedata=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."locale WHERE status=1 OR name='".DEFAULT_LOCALE."'");
	    $this->set_result('localedata',$localedata);
	    }
	}
	function edit_cities_action()
	{
		//sleep(2);
	    $db= DBLayer::get_instance();
		$this->disable_notice_area();
		
		
		$language_enabled=Settings::get_instance()->read('language_enabled');
		
		$id=$this->read_post_param('id');
		$city=$this->read_post_param('city');
		$country=$this->read_post_param('country');
		$state=$this->read_post_param('state');
		$city_english=$this->read_post_param('city_english');
		
		
		
		
		
		$city=str_replace('-',' ',$city);
		$city_english=str_replace('-',' ',$city_english);
		
		if($state=="")
		$state="00";
		
		
		
		if($language_enabled ==1){
		$localedata=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."locale WHERE status=1 OR name='".DEFAULT_LOCALE."'");
		$locale1='';
		$locale2=array();
		while($localerow=$localedata->fetch_assoc())
		{
			$submitvalue=trim($this->read_post_param($localerow['id'].'_city_edit_'.$id));
			$submitvalue=str_replace('-',' ',$submitvalue);
			
		
			if($locale1 !='')
			$locale1.=',';
		
			$locale1.=$localerow['id'].'_city=?';
			$locale2[]=$submitvalue;
		}
		}
		
		if(DEMO_MODE)
		{
			echo 4;
			exit;
		}
		
		
		
		
		if($country=="" || $city=="" || $id=="" || $id <=0 || $city_english=="")
		{
			echo 1;
			exit;
		}
		else
		{
			$already=$db->read_single_column("select count(id) from ".TABLE_PREFIX."cities where ccode=? and scode=? and city=? and id<>?",array($country,$state,$city,$id));
			$already_english=$db->read_single_column("select count(id) from ".TABLE_PREFIX."cities where ccode=? and scode=? and english_name=? and id<>?",array($country,$state,$city_english,$id));
			
			if($already >0 || $already_english >0)
			{
				echo 2;
				exit;
			}
			else
			{
				$res=$db->execute_query("UPDATE ".TABLE_PREFIX."cities set city=?,english_name=? where ccode=? and id=?",array($city,$city_english,$country,$id));
				
				
				if($language_enabled ==1){
				if($locale1 !='' && count($locale2) >0)
				{
					$locale2[]=$id;
					$db->execute_query("UPDATE ".TABLE_PREFIX."cities SET ".$locale1." WHERE id=?",$locale2);
				}
				}
				
				
				
				echo 3;
				exit;
			}
		}
	}

	
	function add_action()
	{
		$this->set_title($this->get_label('add city'));
		
		$language_enabled=Settings::get_instance()->read('language_enabled');
		
		if($_POST)
		{
		    $db= DBLayer::get_instance();
			
			$country=$this->read_post_param('country');
			$state=$this->read_post_param('state');
			$city=$this->read_post_param('city');
			$english_name=$this->read_post_param('english_name');
			
			$city=str_replace('-',' ',$city);
			$english_name=str_replace('-',' ',$english_name);
			
			
			if($state=="")
			$state="00";
			
			
			if($language_enabled ==1){
			$localedata=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."locale WHERE status=1 OR name='".DEFAULT_LOCALE."'");
			$locale1='';
			$locale2=array();
			while($localerow=$localedata->fetch_assoc())
			{
				$submitvalue=trim($this->read_post_param($localerow['id'].'_city'));
			
				$this->set_variable($localerow['id'].'_city',$submitvalue);
			
				if($submitvalue !='')
				{
					if($locale1 !='')
					$locale1.=',';
			
					$locale1.=$localerow['id'].'_city=?';
			
					$locale2[]=$submitvalue;
				}
			}
			}
			
			
			
			
			
			
			
			
			
			if($country=="" || $city=="" || $english_name=="")
			{
				$this->flash($this->get_message('mandatory'), $this->make_url('location/manage'),0);
				exit;
			}
			else 
			{
				
			$already=$db->read_single_column("select count(id) from ".TABLE_PREFIX."cities where ccode=? and scode=? and city=?",array($country,$state,$city));
			$already_english=$db->read_single_column("select count(id) from ".TABLE_PREFIX."cities where ccode=? and scode=? and english_name=?",array($country,$state,$english_name));
			
			
			if($already >0 || $already_english >0)
			{
				$this->flash($this->get_message('already added city'), $this->make_url('location/manage/').$country."/".$state,0);
				exit;
			}
			else 
			{
			
				$res=$db->execute_query("INSERT INTO ".TABLE_PREFIX."cities (`ccode`,`city`,`scode`,`english_name`) values (?,?,?,?)",array($country,$city,$state,$english_name));
				
				$lid=$res->get_last_id();
				
							if($language_enabled ==1){
				
				if($locale1 !='' && count($locale2) >0)
				{
					$locale2[]=$lid;
					$db->execute_query("UPDATE ".TABLE_PREFIX."cities SET ".$locale1." WHERE id=?",$locale2);
				}
							}
			
			
			
			$this->flash($this->get_message('city added'), $this->make_url('location/manage/').$country."/".$state);
			exit;
			
			}
			
			}
			
			
		}
		else
		{
			header("Location:".$this->make_url('location/manage'));
			exit;
		}
	}
	
	function delete_action()
	{
	    $db= DBLayer::get_instance();
		$id=$this->read_page_param(1);
		$ccode=$this->read_page_param(2);
		
		
		if(DEMO_MODE)
		{
			$this->flash($this->get_message('demo mode'), $this->make_url('location/manage/').$ccode,0);
			exit;
		}
		
		$scodes=$db->read_single_column("select scode from ".TABLE_PREFIX."cities WHERE id=?",array($id));
		$count=$db->read_single_column("select count(id) from ".TABLE_PREFIX."items where city=?",array($id));
		
		if($count >0)
		{
			$this->flash($this->get_message('item exists in this city'), $this->make_url('location/manage/').$ccode,0);
			exit;
		}
		else 
		{
			$sql="delete from ".TABLE_PREFIX."cities where id=?";
			$res=$db->execute_query($sql,array($id));
			$this->flash($this->get_message('city deleted'), $this->make_url('location/manage/').$ccode."/".$scodes);
			exit;
		}
	}
	
};