<?php
include_once COMMON_DIR_PATH.'helpers'.DS."login-helper.php";
include_once COMMON_DIR_PATH.'helpers'.DS."utility-helper.php";
class UserController extends AppController
{
function before_execute()
	{
		if(LoginHelper::validate_admin_login()==0)
			{
				$this->flash($this->get_message('login failed'), $this->make_url('index/index'),0);
			}
	}
	
	function manage_action()
	{
		$this->set_title($this->get_label('manage user'));
		
		$db=DBLayer::get_instance();
		
		if($_POST)
		{
			$status=$this->read_post_param("status");
			$membership=$this->read_post_param("membership");
		}
		else 
		{
			$status=$this->read_page_param(1);
			$membership=$this->read_page_param(2);
		}
		
		
		
		$exp=explode("-",$status);
		if($exp[0]=="page")
		$status=-1;
		
		
		$exp1=explode("-",$membership);
		if($exp1[0]=="page")
		$membership=-1;
		
		
		
		if($status=="")
		$status=-1;
		
		if($membership=="")
		$membership=-1;
		
		$this->set_variable("status",$status);
		$this->set_variable("membership",$membership);
		
		$status_str="";
		if($status !=-1)
		$status_str=" where status='".$status."' ";
		
		$member_str="";
		
		if($status_str !="" && $membership !=-1)
		{
			if($membership ==0)
			$member_str=" and plan_expiry=0 ";
			else 
			$member_str=" and plan_expiry >0 ";
		}
		
		if($status_str =="" && $membership !=-1)
		{
			if($membership ==0)
			$member_str=" where plan_expiry=0 ";
			else
			$member_str=" where plan_expiry >0 ";
		}

		$sql="select * from ".TABLE_PREFIX."users ".$status_str.$member_str." order by id desc";
		$pagination = new Pagination($sql);
		$res=$pagination->get_result();
		$this->set_result("res",$res);
		$this->set_variable("pagination",$pagination->links(),0);
		
		$pg=$pagination->get_page_number();
		$this->set_variable("pg","page-".$pg);
		

	}

	function block_action()
	{

		$id=$this->read_page_param(1);
		$from=$this->read_page_param(2);
		$membership=$this->read_page_param(3);
		
		$pg=$this->read_page_param(4);
		
		
		
		$pgnew=explode("-",$pg);
		if($pgnew[0] !="page")
		$pg="";
		
		
		if($pg=="")
		$pg="page-1";
		
		if(!$this->get_user_exists($id))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('user/manage/'.$from.'/'.$membership.'/'.$pg),0);
			exit;
		}
		
		$db=DBLayer::get_instance();
		if(!DEMO_MODE ||(DEMO_MODE == TRUE && $row['id']!=1))
		{
			$db->execute_query("update ".TABLE_PREFIX."users set status=0 where id=?",array($id));
			
			
			
			// newsletter addon support///
			
			
			
			
			$newsletteraddon_folder=$this->xyz_get_addon_folder_name("XYZCLSNLR");
			$newsletter_enable=$this->get_addon_status($newsletteraddon_folder.'_enabled');
			
			if($newsletter_enable ==1){
			
			
			
				$existing_email= $db->execute_query("select email,status  from ".TABLE_PREFIX."users where id = ?",array($id));
				//print_r($existing_email['email']);die;
				$row=$existing_email->fetch_assoc();
			
				if($existing_email !="")
				{
					$this->email_mapping_update($row['email'],$row['status']);
							
			
				}
			
			}
			
			/////////////////////////////////////////////////////////////////////////////////////////////
			
			
			
			
			
			
			$this->flash($this->get_message('user blocked'), $this->make_url('user/manage/'.$from.'/'.$membership.'/'.$pg));
			die;
		}
		else
		{
			$this->flash($this->get_message('demo mode'), $this->make_url('user/manage/'.$from.'/'.$membership.'/'.$pg),0);
			exit;
		}
	}
	
	function delete_action()
	{
		
		$id=$this->read_page_param(1);
		$from=$this->read_page_param(2);
		$membership=$this->read_page_param(3);
		
		$pg=$this->read_page_param(4);
		
		
		
		$pgnew=explode("-",$pg);
		if($pgnew[0] !="page")
		$pg="";
		
		if($pg=="")
		$pg="page-1";
		
		if(!$this->get_user_exists($id))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('user/manage/'.$from.'/'.$membership.'/'.$pg),0);
			exit;
		}
		

		$db=DBLayer::get_instance();
		
		
		
		if(!DEMO_MODE ||(DEMO_MODE == TRUE && $row['id']!=1))
		{
			$count=$db->read_single_column("select count(id) from ".TABLE_PREFIX."items where user=?",array($id));
			if($count >0)
			{
				$idrow=$db->execute_query("SELECT id FROM ".TABLE_PREFIX."items where user=?",array($id));
				while($idrowdate=$idrow->fetch_assoc())
				{
					$itemcategory=$this->get_item_category($idrowdate['id']);
					$lastpid=intval($this->get_last_parent_id($itemcategory));
					
					$db->execute_query("DELETE FROM ".TABLE_PREFIX."customfields_".$lastpid." WHERE itemid=?",array($idrowdate['id']));
					$db->execute_query("DELETE FROM ".TABLE_PREFIX."customfields_0 WHERE itemid=?",array($idrowdate['id']));
					$db->execute_query("DELETE FROM ".TABLE_PREFIX."notification WHERE itemid=?",array($idrowdate['id']));
					
					
					$mydir = '../'.DATA_DIR.DIRECTORY_SEPARATOR.$idrowdate['id'].DIRECTORY_SEPARATOR;
					$d = dir($mydir);
					if($d)
					{
						while($entry = $d->read())
						{
							if ($entry!= "." && $entry!= "..")
							unlink('../'.DATA_DIR.DIRECTORY_SEPARATOR.$idrowdate['id'].DIRECTORY_SEPARATOR.$entry);
						}
						$d->close();
						rmdir($mydir);
					}
				}
				$db->execute_query("DELETE FROM ".TABLE_PREFIX."items WHERE user=?",array($id));
			}
			
			
			
			
			
			// newsletter addon support///
			
			$newsletteraddon_folder=$this->xyz_get_addon_folder_name("XYZCLSNLR");
			$newsletter_enable=$this->get_addon_status($newsletteraddon_folder.'_enabled');
			
			if($newsletter_enable ==1){
			
			
			
				$existing_email= $db->execute_query("select email,status  from ".TABLE_PREFIX."users where id = ?",array($id));
			
				$row=$existing_email->fetch_assoc();
			
				if($existing_email !="")
				{
			
					$id =$db->read_single_column("select id from ".TABLE_PREFIX."email_address where email = ?",array($row['email']));
							
					$db->execute_query("delete from ".TABLE_PREFIX."additional_field_value where ea_id=?",array($id));
					$db->execute_query("delete from ".TABLE_PREFIX."address_list_mapping where ea_id=?",array($id));
					$db->execute_query("delete from ".TABLE_PREFIX."email_address where id=?",array($id));
			
			
			
					//delete email adddess
			
			
				}
			}
			//////////////////////////
			
			$db->execute_query("DELETE FROM ".TABLE_PREFIX."users WHERE id=?",array($id));
			$db->execute_query("DELETE FROM ".TABLE_PREFIX."favourites WHERE userid=?",array($id));
			
			
			
			$db->execute_query("DELETE FROM ".TABLE_PREFIX."notification WHERE uid=?",array($id));
			
			
			$this->flash($this->get_message('user deleted'), $this->make_url('user/manage/'.$from.'/'.$membership.'/'.$pg));
			exit;
		}
		else
		{
			$this->flash($this->get_message('demo mode'), $this->make_url('user/manage/'.$from.'/'.$membership.'/'.$pg),0);
			exit;
		}	
	}

	function activate_action()
	{
		$id=$this->read_page_param(1);
		$from=$this->read_page_param(2);
		$membership=$this->read_page_param(3);
		
		$pg=$this->read_page_param(4);
		
		$pgnew=explode("-",$pg);
		if($pgnew[0] !="page")
		$pg="";
		
		if($pg=="")
		$pg="page-1";
		
		if(!$this->get_user_exists($id))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('user/manage/'.$from.'/'.$membership.'/'.$pg),0);
			exit;
		}
		
		
		
		
		$db=DBLayer::get_instance();

		$res123=$db->execute_query("select email,status from ".TABLE_PREFIX."users where id=?",array($id));
		$result123=$res123->fetch_assoc();
		$email123=$result123['email'];
		$status123=$result123['status'];
		




		$db->execute_query("update ".TABLE_PREFIX."users set status=1 where id=?",array($id));


		if($status123 ==-2)
		{
			$item_status123=Settings::get_instance()->read('default_item_status');
			$db->execute_query("update ".TABLE_PREFIX."items set user=?,status=? where user=0 AND email=?",array($id,$item_status123,$email123));
		}
		
		// newsletter addon support///
		$newsletteraddon_folder=$this->xyz_get_addon_folder_name("XYZCLSNLR");
		$newsletter_enable=$this->get_addon_status($newsletteraddon_folder.'_enabled');
		
		if($newsletter_enable ==1){
		$existing_email= $db->execute_query("select email,status  from ".TABLE_PREFIX."users where id = ?",array($id));
			$row=$existing_email->fetch_assoc();
		
			if($existing_email !="")
			{
				$this->email_mapping_update($row['email'],$row['status']);
		
		
			}
		
		}
		
		/////////////////////////////////////////////////////////////////////////////////////////////
		


		$this->flash($this->get_message('user activated'), $this->make_url('user/manage/'.$from.'/'.$membership.'/'.$pg));
		die;

	}
	
	function profile_action()
	{
		$this->set_title($this->get_label('user profile'));
		
		$id=$this->read_page_param(1);
		
		if(!$this->get_user_exists($id))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('user/manage'),0);
			exit;
		}
		
		
		$type=$this->read_page_param(2);
		$status=$this->read_page_param(3);
		$featured=$this->read_page_param(4);
		$categ=$this->read_page_param(5);
		
		
		$pg=$this->read_page_param(6);
		
		
		
		$pgnew=explode("-",$pg);
		if($pgnew[0] !="page")
		$pg="";
		
		
		if($pg=="")
		$pg="page-1";
		
		
		if($type =="")
			$type=-1;
		
		if($status =="")
			$status=-2;
		
		if($featured =="")
			$featured=-1;
		
		if($categ =="")
			$categ=0;
		
		
		
		$this->set_variable("type",$type);
		$this->set_variable("status",$status);
		$this->set_variable("featured",$featured);
		$this->set_variable("categ",$categ);
		
		$this->set_variable("pg",$pg);
		
		
		
		$db=DBLayer::get_instance();
		$res=$db->execute_query("select * from ".TABLE_PREFIX."users where id=?",array($id));
		$this->set_result('res', $res);
	}
	
	
	
	
	function payments_action()
	{
	    $db=DBLayer::get_instance();
		
		$id=$this->read_page_param(1);
		
		$uid=$this->set_variable("uid",$id);
		
		if(!$this->get_user_exists($id))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('user/manage'),0);
			exit;
		}
		
		
		$type=$this->read_post_param("type");
		$type_str="";
		
		if($type =="")
			$type=0;
		
		
		if($type ==1)
		$type_str= " AND payment=1 ";
		else if($type ==2)
		$type_str= " AND payment=2 ";
		
		
		
		$sql="select * from ".TABLE_PREFIX."payment_summary where uid=? ".$type_str." order by id desc";
		$pagination1 = new Pagination($sql,array($id));
		$res2=$pagination1->get_result();
		$this->set_result("res2",$res2);
		$this->set_variable("pagination1",$pagination1->links(),0);
		
		$this->set_variable("type", $type);
		
	}
	

	
	
	
	function items_action()
	{
	    $db=DBLayer::get_instance();
		
	
		if($_POST)
		$id=$this->read_post_param("uid");
		else
		$id=$this->read_page_param(1);
		
		
		$uid=$this->set_variable("uid",$id);
		
		if($_POST)
		{
			$type=$this->read_post_param("type");
			$status=$this->read_post_param("status");
			$featured=$this->read_post_param("featured");
			$categ=$this->read_post_param("catid");
		}
		else
		{
			$type=$this->read_page_param(2);
			$status=$this->read_page_param(3);
			$featured=$this->read_page_param(4);
			$categ=$this->read_page_param(5);
		}
		
		
		
		
		if(!$this->get_user_exists($id))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('user/manage'),0);
			exit;
		}
		
		
		
		if($type =="")
		$type=-1;
		
		if($status =="")
		$status=-2;
		
		if($featured =="")
		$featured=-1;
		
		if($categ =="")
		$categ=0;
		
		
		
		$type_str="";
		$status_str="";
		$featured_str="";
		$cat_str="";
		
		
		
		
		if($type !=-1)
		$type_str=" and type='".$type."' ";
		
		if($status !=-2)
		$status_str=" and status='".$status."' ";
		
		
		
		if($featured !=-1)
		{	
			if($featured==0)
			$featured_str=" and featured=0 ";
			else if($featured==1)
			$featured_str=" and featured=1 ";
			else if($featured==2)
			$featured_str=" and home_listing=1 ";
			else if($featured==3)
			$featured_str="and featured=0 and home_listing=1 ";
			else if($featured==4)
			$featured_str="and featured=1 and home_listing=1 ";
		}
		
		
		
		
		
		
		
		
		$astr="";
		if($categ !=0)
		{
			//$cat_str=" and category='".$categ."' ";
		
			$childs=$this->display_childs($categ);
			$childs=substr($childs,0,-1);
		
		
		
			$astr="";
		
			if($childs !="")
			{
				$cudata_arr=explode("_",$childs);
		
				if(count($cudata_arr) >0)
				{
					for($k=0;$k< count($cudata_arr); $k++)
					{
					$astr.=" ,$cudata_arr[$k] ";
			}
		}
		}
		
		
		
		$astr='and category IN ('.$categ.$astr.') ';
		}
		
		
		
		$this->set_variable("type",$type);
		$this->set_variable("status",$status);
		$this->set_variable("featured",$featured);
		$this->set_variable("categ",$categ);
		
	
		
		
		
		$sql1="select * from ".TABLE_PREFIX."items where user=? ".$astr.$type_str.$status_str.$featured_str." order by update_time desc";
		$pagination = new Pagination($sql1,array($id));
		$res1=$pagination->get_result();
		$this->set_result("res1",$res1);
		$this->set_variable("pagination",$pagination->links(),0);
		
		
		$pg=$pagination->get_page_number();
		$this->set_variable("pg","page-".$pg);
		
		
		$categories="<option value='0'>".$this->get_label('select')."</option>";
		$categories.=$this->get_category_display(0,0,$categ);
		$this->set_variable("categories",$categories,0);
		
	}
	function login_action()
	{
		$uid=$this->read_page_param(1);
		
		
		if(!$this->get_user_exists($uid))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('user/manage'),0);
			exit;
		}
		
		
		
		
		$db= DBLayer::get_instance();
		
		$res1=$db->execute_query("select email,password from ".TABLE_PREFIX."users where id=? AND status=1",array($uid));

		if($res1->get_num_records() >0)
		{
			$value1=$res1->fetch_assoc();
			$username=$value1['email'];
			$password=$value1['password'];
			
			setcookie(COOKIE_LOGINID,$uid,0,$this->get_base_path(),$this->get_base_domain());
			setcookie(COOKIE_USERNAME,$username,0,$this->get_base_path(),$this->get_base_domain());
			setcookie(COOKIE_PASSWORD,$password,0,$this->get_base_path(),$this->get_base_domain());
			
			header("Location: ".$this->make_base_url("user/home"));
			exit;
		}
		else
		{
			$this->flash($this->get_message('inactive user'), $this->make_url('user/manage'),0);
			exit;
		}
	}
	
	function remove_membership_action()
	{
		$uid=$this->read_page_param(1);
		$from=$this->read_page_param(2);
		$status=$this->read_page_param(3);
		$mship=$this->read_page_param(4);
		$pg=$this->read_page_param(5);
		
		if(!$this->get_user_exists($uid))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('user/manage'),0);
			exit;
		}
		
		
		if(Settings::get_instance()->read('enable_paid_membership') ==0)
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('user/manage'),0);
			exit;
		}
		
		
		
		
		$db=DBLayer::get_instance();
		
		$db->execute_query("UPDATE ".TABLE_PREFIX."users SET plan_expiry=0 WHERE id=?",array($uid));
		
		$this->flash($this->get_message('paid membership remove'), $this->make_url('user/membership/'.$uid."/".$from."/".$status."/".$mship."/".$pg));
		exit;
		
	}
	
	
	function membership_action()
	{
		$this->set_title($this->get_label('make premium member'));
		
		
		if($_POST)
		{
			$uid=$this->read_post_param("uid");
			$plan=$this->read_post_param("plans");
			$from=$this->read_post_param("from");
			$pg=$this->read_post_param("pg");
			$status=$this->read_post_param("status");
			$mship=$this->read_post_param("mship");
			
		}
		else
		{	
			$uid=$this->read_page_param(1);
			$from=$this->read_page_param(2);
			$status=$this->read_page_param(3);
			$mship=$this->read_page_param(4);
			$pg=$this->read_page_param(5);
			
			$plan=0;
		}
		
		
		
		if($pg !="")
		{
			$pgnew=explode("-",$pg);
			if($pgnew[0] !="page")
			$pg="";
		}
		else
			$pg="";
		
		
		if($pg=="")
		$pg="page-1";
		
		
		if($plan=="")
		$plan=0;
		
		
		
		if($status=="")
		$status=-1;
		
		if($mship=="")
		$mship=-1;
		
		
		
		$this->set_variable('plan', $plan);
		$this->set_variable('uid', $uid);
		$this->set_variable('from', $from);
		$this->set_variable('pg', $pg);
		$this->set_variable('status', $status);
		$this->set_variable('mship', $mship);
		
		
		$db= DBLayer::get_instance();
		
		
		$oldexpiry=$db->read_single_column("SELECT plan_expiry from ".TABLE_PREFIX."users WHERE id=".$uid);
		$this->set_variable('oldexpiry', $oldexpiry);
		
		
		
		if(Settings::get_instance()->read('enable_paid_membership') ==0)
		{
			if($from==1)
			$this->flash($this->get_message('invalid operation'), $this->make_url('user/profile/'.$uid),0);
			else
			$this->flash($this->get_message('invalid operation'), $this->make_url('user/manage/'.$status.'/'.$mship.'/'.$pg),0);
			
			exit;
		}
		
		if($_POST)
		{
		
			if($plan !=0)
			{
			
				if(!$this->get_active_membership_plan($plan))
				{
					if($from==1)
					$this->flash($this->get_message('invalid operation'), $this->make_url('user/profile/'.$uid),0);
					else 
					$this->flash($this->get_message('invalid operation'), $this->make_url('user/manage/'.$status.'/'.$mship.'/'.$pg),0);
					
					exit;
				}
			
			
				$days=$db->read_single_column("SELECT days from ".TABLE_PREFIX."membershipplans where id='$plan'");
				
				
			
				$t=time();
				
			
				if($oldexpiry >0)
				$expiry=gmmktime(gmdate("H",$oldexpiry),gmdate("i",$oldexpiry),gmdate("s",$oldexpiry),gmdate("m",$oldexpiry),gmdate("d",$oldexpiry)+$days,gmdate("Y",$oldexpiry));
				else
				$expiry=gmmktime(gmdate("H",$t),gmdate("i",$t),gmdate("s",$t),gmdate("m",$t),gmdate("d",$t)+$days,gmdate("Y",$t));
				
				
				
				
				
				
				if($oldexpiry > $expiry)
				$expiry=$oldexpiry;
				
				
				$error_flag=0;
				
				
				
					$result=$db->execute_query("UPDATE ".TABLE_PREFIX."users set plan_expiry=? where id=?",array($expiry,$uid));
					if($result->get_error() !="")
					$error_flag=1;
					else 
					{				
				
						/////////////////////////////////////////////////////////////////////////////
						
						$default_status=Settings::get_instance()->read('default_item_status');	
						$adexpiry=Settings::get_instance()->read("ad_expiry");
						
						$listrow=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."items WHERE status=-3 AND user=?",array($uid));
						
						while($listdata=$listrow->fetch_assoc())
						{
							$paid_array=$this->get_paid_option($listdata['category'],$listdata['user']);
							$paid_array_data=explode('-',$paid_array);
						
							$paid_listing=intval($paid_array_data[1]);		
									
							
							if($paid_listing ==1)
							{
								if($default_status !=1)
								$update=$db->execute_query("UPDATE ".TABLE_PREFIX."items SET status=? WHERE id=? AND user=?",array($default_status,$listdata['id'],$uid));
								else
								{
									$time_arr=getdate(time());
									$gmtime=gmmktime($time_arr['hours'],$time_arr['minutes'],$time_arr['seconds'],$time_arr['mon'],$time_arr['mday']+$adexpiry,$time_arr['year']);
										
									$update=$db->execute_query("UPDATE ".TABLE_PREFIX."items SET status=?,expiry_time=? WHERE id=? AND user=?",array($default_status,$gmtime,$listdata['id'],$uid));
								}
								
								
								if($update->get_error() !="")
								{
									$error_flag=1;
									break;
								}
							}
						}
						/////////////////////////////////////////////////////////////////////////				
					}
				
				

				if($error_flag ==0)
				{	
					$db->execute_query("DELETE FROM ".TABLE_PREFIX."notification WHERE uid=? AND type=1",array($uid));
					
					if($from==1)
					$this->flash($this->get_message('membership update success'), $this->make_url('user/profile/'.$uid));
					else
					$this->flash($this->get_message('membership update success'), $this->make_url('user/manage/'.$status.'/'.$mship.'/'.$pg));
				}
				else
				{
					if($from==1)
					$this->flash($this->get_message('membership update failed'), $this->make_url('user/profile/'.$uid));
					else
					$this->flash($this->get_message('membership update failed'), $this->make_url('user/manage/'.$status.'/'.$mship.'/'.$pg));
				}

				
				exit;
			}
			else
			{
				if($from==1)
				$this->flash($this->get_message('invalid operation'), $this->make_url('user/profile/'.$uid),0);
				else
				$this->flash($this->get_message('invalid operation'), $this->make_url('user/manage/'.$status.'/'.$mship.'/'.$pg),0);
				
				exit;
			}
		}

		
	}
	function bulk_operations_action()
	{
	    $db = DBLayer::get_instance();
        $this->disable_notice_area();
        $operation = intval($this->read_post_param('operationhidden'));
        $ids = explode(',', $this->read_post_param('idshidden'));
        $filterhidden_post = $this->read_post_param('filterhidden');
        $filterhidden = explode('/', $filterhidden_post);
        $block_success = 0;
        $enable_success = 0;
        $engine_name = Settings::get_instance()->read('engine_name');
        $status = $filterhidden[0];
        $membership = $filterhidden[1];
        $pg = $filterhidden[2];
        $pgnew = explode("-", $pg);
        if ($pgnew[0] != "page")
            $pg = "";
        if ($pg == "")
            $pg = "page-1";
        if ($types == "")
            $types = - 1;
        if ($status == "")
            $status = - 1;
        if ($membership == "")
            $membership = - 1;
        if ($operation == 0 && count($ids) > 0)
        {
            foreach ($ids as $key => $id)
            {
                $res = $db->execute_query("select * from " . TABLE_PREFIX . "users where id=? and status=1", array(
                    $id
                ));
                if ($res->num_records > 0) {
                    $db->execute_query("update ".TABLE_PREFIX."users set status=0 where id=?",array($id));
                    $block_success=$block_success+1;
                    $newsletteraddon_folder=$this->xyz_get_addon_folder_name("XYZCLSNLR");
                    $newsletter_enable=$this->get_addon_status($newsletteraddon_folder.'_enabled');
                    if($newsletter_enable ==1){
                        $existing_email= $db->execute_query("select email,status  from ".TABLE_PREFIX."users where id = ?",array($id));
                        //print_r($existing_email['email']);die;
                        $row=$existing_email->fetch_assoc();
                        if($existing_email !="")
                        {
                            $this->email_mapping_update($row['email'],$row['status']);
                        }
                    }
                }
            }
        } else if ($operation == 1) {
            // activate
            foreach ($ids as $key => $id) 
            {
                $res=$db->execute_query("SELECT *  FROM ".TABLE_PREFIX."users where id=? AND status=0",array($id));
                if ($res->num_records > 0) 
                {
                $res123=$db->execute_query("select email,status from ".TABLE_PREFIX."users where id=?",array($id));
                $result123=$res123->fetch_assoc();
                $email123=$result123['email'];
                $status123=$result123['status'];
                $db->execute_query("update ".TABLE_PREFIX."users set status=1 where id=?",array($id));
                $enable_success=$enable_success+1;
                if($status123 ==-2)
                {
                    $item_status123=Settings::get_instance()->read('default_item_status');
                    $db->execute_query("update ".TABLE_PREFIX."items set user=?,status=? where user=0 AND email=?",array($id,$item_status123,$email123));
                }
                // newsletter addon support///
                $newsletteraddon_folder=$this->xyz_get_addon_folder_name("XYZCLSNLR");
                $newsletter_enable=$this->get_addon_status($newsletteraddon_folder.'_enabled');
                if($newsletter_enable ==1)
                {
                    $existing_email= $db->execute_query("select email,status  from ".TABLE_PREFIX."users where id = ?",array($id));
                    $row=$existing_email->fetch_assoc();
                    if($existing_email !="")
                    {
                        $this->email_mapping_update($row['email'],$row['status']);
                    }
                }
                }
            }
        }
        $msg = '';
        if ($block_success > 0) {
            $msg = $this->get_message('users has blocked', array(
                'x' => $block_success
            ));
        } else if ($enable_success > 0) {
            $msg = $this->get_message('users has activated', array(
                'x' => $enable_success
            ));
        }  else {
            $msg = $this->get_message('no operation');
        }
        $types = $filterhidden[0];
        $statuss = $filterhidden[1];
        $featureds = $filterhidden[2];
        $categs = $filterhidden[3];
        $pg = $filterhidden[4];
        $this->flash($msg, $this->make_url('user/manage/' . $status . '/' . $membership.'/' . $pg));
    }
};
?>
