<?php
include_once COMMON_DIR_PATH.'helpers'.DS."login-helper.php";
include_once COMMON_DIR_PATH.'helpers'.DS."utility-helper.php";

class PaymentController extends AppController
{
	function before_execute()
	{
		parent::before_execute();
		if($this->get_action()=="details")
		{
			if(LoginHelper::validate_user_login()==0)
			{
				$this->flash($this->get_message('login failed'), $this->make_base_url('user/login_register'),0);
			}
		}
	}
	
	
	private $fullipn='';
	
	function paypal_ipn_action()
	{
			

        $verify_url = "https://ipnpb.paypal.com/cgi-bin/webscr";
        //$verify_url = 'https://ipnpb.sandbox.paypal.com/cgi-bin/webscr';
        $raw_post_data = file_get_contents('php://input');
        $raw_post_array = explode('&', $raw_post_data);
        $myPost = array();
        foreach ($raw_post_array as $keyval) {
            $keyval = explode('=', $keyval);
            if (count($keyval) == 2) {
                // Since we do not want the plus in the datetime string to be encoded to a space, we manually encode it.
                if ($keyval[0] === 'payment_date') {
                    if (substr_count($keyval[1], '+') === 1) {
                        $keyval[1] = str_replace('+', '%2B', $keyval[1]);
                    }
                }
                $myPost[$keyval[0]] = urldecode($keyval[1]);
            }
        }
        // Build the body of the verification post request, adding the _notify-validate command.
		$req = 'cmd=_notify-validate';
        $get_magic_quotes_exists = false;
        if (function_exists('get_magic_quotes_gpc')) {
            $get_magic_quotes_exists = true;
        }
        foreach ($myPost as $key => $value) {
            if ($get_magic_quotes_exists == true && get_magic_quotes_gpc() == 1) {
                $value = urlencode(stripslashes($value));
            } else {
                $value = urlencode($value);
            }
            $req .= "&$key=$value";
		}
        // Post the data back to PayPal, using curl. Throw exceptions if errors occur.
        
        $ch = curl_init($verify_url);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $req);
        curl_setopt($ch, CURLOPT_SSLVERSION, 6);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        // This is often required if the server is missing a global cert bundle, or is using an outdated one.
        curl_setopt($ch, CURLOPT_CAINFO, LIB_DIR_PATH.'paypal-cert/cacert.pem');
        curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Connection: Close'));
        $res = curl_exec($ch);
        if ( ! ($res)) {
            $errno = curl_errno($ch);
            $errstr = curl_error($ch);
            curl_close($ch);
            $this->log_trans("cURL error: [$errno] $errstr");
            die;
        }
        $info = curl_getinfo($ch);
        
        $http_code = $info['http_code'];
        if ($http_code != 200) {
            $this->log_trans("PayPal responded with http code $http_code");
            die;
        }
        curl_close($ch);
		// Assign posted variables to local variables
		$item_name = $this->read_post_param('item_name');
		$item_number = $this->read_post_param('item_number');
		$payment_status = $this->read_post_param('payment_status');
		$payment_amount = $this->read_post_param('mc_gross');
		$payment_currency =$this->read_post_param('mc_currency');
		$txn_id = $this->read_post_param('txn_id');
		$receiver_email = $this->read_post_param('business');
		$payer_email = $this->read_post_param('payer_email');
		$txn_type = $this->read_post_param('txn_type');
		$pending_reason = $this->read_post_param('pending_reason');
		$payment_type = $this->read_post_param('payment_type');
		$userid1 =$this->read_post_param('custom');
		$fee=$this->read_post_param('payment_fee');
		$single=explode("_",$userid1);
		$userid=$single[0];
		$planid=$single[1];
		$home_listing1=intval($single[2]);
		$paid=intval($single[3]);
		$uname=$this->get_user_name($userid);
		
		
		$db= DBLayer::get_instance();
		
		
		
		
		$admin_email=Settings::get_instance()->read('general_notification_email');
		
		$premium_enabled=Settings::get_instance()->read('enable_premium_listing');
		$home_enabled=Settings::get_instance()->read('home_page_listing');
		
		
		
		
		$listing_mode=Settings::get_instance()->read('system_listing_mode');
		
		
		
		
		$default_premium_days=Settings::get_instance()->read('default_premium_listing_period');
		$home_listing_days=Settings::get_instance()->read('home_listing_days');
		
		$paid_listing_days=Settings::get_instance()->read('ad_expiry');
		
		if($planid =='a' || $premium_enabled ==0)	
		$premium_listing=0;
		else
		$premium_listing=1;
		 
		
		if($home_enabled ==1 && $home_listing1 ==1)
		$home_listing=1;
		else
		$home_listing=0;
		
		
		
		
		// Check parameters
	
                        if (!$info)
		{
			// HTTP error
			$this->log_trans("HTTP Error, can't connect to Paypal");
			die;
		}
		else
		{
			$ret = "";
                            
                            
                            


			
				// check that receiver_email is your Primary PayPal email
				$paypal_email=Settings::get_instance()->read('paypal_email');
				if(strcasecmp($receiver_email,$paypal_email) !=0)
				{
					$this->log_trans("Wrong Receiver Email - $item_number");
					die;
				}
				

				// check that txn_id has not been previously processed
				$sql = "SELECT txnid FROM ".TABLE_PREFIX."paypal_ipn WHERE txnid = '$txn_id' AND result = '1'";
				$res1=$db->execute_query($sql);
				$val=$res1->fetch_assoc();
				if($val['txnid']!="")
				{
					// Entry present
					$this->log_trans("Invalid/Duplicate Transaction - $txn_id");
					die;
				}


				
				$res=$db->execute_query("select i.*,c.premium_price,c.rate_per_post from ".TABLE_PREFIX."items i JOIN ".TABLE_PREFIX."categories c ON i.category=c.id where i.id=? AND (i.status=1 OR i.status=-1 OR i.status=-3 )",array($item_number));

				if($res->get_num_records() ==0)
				{
					$this->log_trans("Invalid Item");
					die;
				}
				
				$values=$res->fetch_assoc();
				
				$current_status=$values['status'];
				$featured_expiry=$values['featured_expiry'];
				$normal_expiry=$values['expiry_time'];
				$home_expiry=$values['home_expiry'];
				$paid_status=$values['paid_status'];
								
				$catagory_premium=$values['premium_price'];
				$rate_per_post=$values['rate_per_post'];
				
				
				if($catagory_premium <=0 || $catagory_premium =="")
				$catagory_premium=Settings::get_instance()->read('default_premium_price');
				
				if($home_listing ==1)
				$home_listing_rate=Settings::get_instance()->read('home_page_listing_rate');
				else
				$home_listing_rate=0;
					
				
				$paid_listing_rate=0;
				$min_user_transaction_amount=0;
				
				

		
				$paid_listing=0;			
					
				
				if($paid_status ==0)
				{
					$paid_array=$this->get_paid_option($values['category'],$userid);
					$paid_array_data=explode('-',$paid_array);
				
					$paid_listing=$paid_array_data[0];		
				}

				
				if($paid_listing==1)
				{
					if($rate_per_post >0 )
					$paid_listing_rate=$rate_per_post;
					else
					$paid_listing_rate=Settings::get_instance()->read('paid_listing_rate');
					
					$min_user_transaction_amount=round($paid_listing_rate,2);
				}
				
				
				
				
				if($premium_listing ==1)
				{
					if($planid ==0)
                                            {
					$min_user_transaction_amount+=$catagory_premium;
                                            }
					else if($planid >0)
					{
						if(!$this->get_active_payment_plan($planid))
						{
							$this->log_trans("Invalid Payment Plan Id.");
							die;
						}
										
						$plandays1=$db->read_single_column("select num_days from ".TABLE_PREFIX."paymentplans where id=?",array($planid));
                                                $rate1=$db->read_single_column("select rate_amt from ".TABLE_PREFIX."paymentplans where id=?",array($planid));
						
						
						
                                                $min_user_transaction_amount +=$rate1;
                                                
                                                
                                                
                                                
						}
                                            
					$min_user_transaction_amount=round($min_user_transaction_amount,2);
				}
				
				
				if($home_listing ==1)
				$min_user_transaction_amount=$min_user_transaction_amount+$home_listing_rate;
				
				
				$min_user_transaction_amount=round($min_user_transaction_amount,2);
				
				
				
				
 				if($payment_amount < $min_user_transaction_amount)
 				{
 					$this->log_trans("Amount Less than Order Amount - Received: $payment_amount $payment_currency;
 							 Order Amount: $min_user_transaction_amount $paypal_currency");
 					die;
 				}

				$paypal_currency=Settings::get_instance()->read('paypal_currency');
				if ($payment_currency != $paypal_currency)
				{
					$this->log_trans("Wrong Currency - Received: $payment_currency; Expected: $paypal_currency");
					die;
				}

				// check the payment_status is Completed
				if ($payment_status != "Completed")
				{
					$this->log_trans("Incomplete Payment - Payment Status: $payment_status");
					die;
				}
				
				
				$db->execute_query("begin");
				$error_flag=0;
				
				$payment_id=$this->log_trans("Success");
				if($payment_id >0)
				{
					

					
					
					if($paid_listing ==1)
					{
						if($current_status ==-3 )
						{
							$current_status=Settings::get_instance()->read('default_item_status');
						
							/////////////////////////////////////////////
							
							$result_num123=$db->execute_query("UPDATE ".TABLE_PREFIX."items set status=? where id=?",array($current_status,$item_number));
							
							if($result_num123->get_error() !="")
							$error_flag=1;
							
							/////////////////////////////////////////////
							
						}
						

						if($error_flag ==0)
						{
							if($current_status ==-1 )
							{
								$result_num=$db->execute_query("UPDATE ".TABLE_PREFIX."items set paid_status=1,paid_days=paid_days+? where id=?",array($paid_listing_days,$item_number));
								if($result_num->get_error()!="")
								$error_flag=1;
							}
							if($current_status ==1 )
							{
								$new_expiry1=gmmktime(gmdate("H",$normal_expiry),gmdate("i",$normal_expiry),gmdate("s",$normal_expiry),gmdate("m",$normal_expiry),gmdate("d",$normal_expiry)+$paid_listing_days,gmdate("Y",$normal_expiry));
							
							
								if($normal_expiry < $new_expiry1 )
								$normal_expiry=$new_expiry1;
							
								$result_num=$db->execute_query("UPDATE ".TABLE_PREFIX."items set paid_status=1,expiry_time=?,paid_days=0 where id=?",array($normal_expiry,$item_number));
								if($result_num->get_error()!="")
								$error_flag=1;
							}
						}
					}
					
					
					if($premium_listing ==1)
					{
						if($planid ==0)
						{
							if($featured_expiry >0)
							$new_expiry=gmmktime(gmdate("H",$featured_expiry),gmdate("i",$featured_expiry),gmdate("s",$featured_expiry),gmdate("m",$featured_expiry),gmdate("d",$featured_expiry)+$default_premium_days,gmdate("Y",$featured_expiry));
							else
							$new_expiry=gmmktime(gmdate("H",time()),gmdate("i",time()),gmdate("s",time()),gmdate("m",time()),gmdate("d",time())+$default_premium_days,gmdate("Y",time()));
						
							$num_days=$default_premium_days;
						}
						else if($planid >0)
						{
							$num_days=$db->read_single_column("select num_days from ".TABLE_PREFIX."paymentplans where id=?",array($planid));
						
							if($featured_expiry >0)
							$new_expiry=gmmktime(gmdate("H",$featured_expiry),gmdate("i",$featured_expiry),gmdate("s",$featured_expiry),gmdate("m",$featured_expiry),gmdate("d",$featured_expiry)+$num_days,gmdate("Y",$featured_expiry));
							else
							$new_expiry=gmmktime(gmdate("H",time()),gmdate("i",time()),gmdate("s",time()),gmdate("m",time()),gmdate("d",time())+$num_days,gmdate("Y",time()));
						}
					
						
						if($current_status ==-1)
						{
							$result_num=$db->execute_query("UPDATE ".TABLE_PREFIX."items set no_of_days=no_of_days+? where id=?",array($num_days,$item_number));
							if($result_num->get_error()!="")
							$error_flag=1;
						}
						
						$result=$db->execute_query("UPDATE ".TABLE_PREFIX."items set featured=? where id=?",array(1,$item_number));
						if($result->get_error() !="")
						$error_flag=1;
						else 
						$db->execute_query("DELETE FROM ".TABLE_PREFIX."notification WHERE itemid=? AND type=2",array($item_number));
							
					}
										
					
					if($home_listing ==1)
					{
						$result=$db->execute_query("UPDATE ".TABLE_PREFIX."items set home_listing=? where id=?",array(1,$item_number));
						if($result->get_error() !="")
						$error_flag=1;
						else 
						$db->execute_query("DELETE FROM ".TABLE_PREFIX."notification WHERE itemid=? AND type=3",array($item_number));
							
					}
					
					if($current_status ==-1 && $home_listing ==1)
					{
						$home_days=Settings::get_instance()->read('home_listing_days');
						$result_num=$db->execute_query("UPDATE ".TABLE_PREFIX."items set home_days=home_days+? where id=?",array($home_days,$item_number));
						if($result_num->get_error()!="")
						{
							$error_flag=1;
						}
					}
					
					

					
										
					if($current_status ==1 && $premium_listing ==1)
					{
						if($normal_expiry < $new_expiry && $paid_listing ==0)
						$normal_expiry=$new_expiry;
						
						
						$result=$db->execute_query("UPDATE ".TABLE_PREFIX."items set featured_expiry=?,expiry_time=? where id=?",array($new_expiry,$normal_expiry,$item_number));
						if($result->get_error() !="")
						{
							$error_flag=1;
						}
					}
					
					if($current_status ==1 && $home_listing ==1)
					{
						if($home_expiry >0)
						$new_home_expiry=gmmktime(gmdate("H",$home_expiry),gmdate("i",$home_expiry),gmdate("s",$home_expiry),gmdate("m",$home_expiry),gmdate("d",$home_expiry)+$home_listing_days,gmdate("Y",$home_expiry));
						else
						$new_home_expiry=gmmktime(gmdate("H",time()),gmdate("i",time()),gmdate("s",time()),gmdate("m",time()),gmdate("d",time())+$home_listing_days,gmdate("Y",time()));
						
						
						
						$normal_expiry=$db->read_single_column("SELECT expiry_time FROM ".TABLE_PREFIX."items WHERE id=?",array($item_number));
						
						if($normal_expiry < $new_home_expiry && $paid_listing ==0)
						$normal_expiry=$new_home_expiry;
					
					
						$result=$db->execute_query("UPDATE ".TABLE_PREFIX."items set home_expiry=?,expiry_time=? where id=?",array($new_home_expiry,$normal_expiry,$item_number));
						if($result->get_error()!="")
						{
							$error_flag=1;
						}
					}
				}
				else
				$error_flag=1;
				
				
				$dbstatusmsg_admin='';
				if($error_flag==1)
				{
					$db->execute_query("rollback");
					$dbstatusmsg_admin='The database entries related to the payment could not be added. Please do it manually';
				}
				else
				{
					$db->execute_query("commit");
					$dbstatusmsg_admin='The database entries related to the payment were successfully captured.';
				}

				
				$namestring='';
				
				
				
				
				if($paid_listing ==1)
				$namestring.=$this->get_label('paid posting');
				
						
				if($premium_listing ==1)
				{
					if($namestring !='')
					$namestring.=' , ';
					
					$namestring.=$this->get_label('premium list');
				}
				
				if($home_listing ==1)
				{
					if($namestring !='')
					$namestring.=' , ';
					
					$namestring.=$this->get_label('home list');
				}
					
				
				$paymentname=$namestring;
		
				
				
				
				

				$res1=$db->execute_query("select sub,body from ".TABLE_PREFIX."emailtemplates where id=5");
				$result1=$res1->fetch_assoc();
				$subject=$result1['sub'];
				$message=$result1['body'];


				$message=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$message);
				$subject=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$subject);
				
				$message=str_ireplace("{AMT}", $payment_amount.$payment_currency,$message);
				$message=str_ireplace("{USERNAME}", $this->get_user_name($userid),$message);
				$message=str_ireplace("{ITEMNAME}", $item_name,$message);
				$message=str_ireplace("{PAYMENTFOR}", $paymentname,$message);
				
				$message=str_ireplace("{TXNID}", $txn_id,$message);
				$message=str_ireplace('{DBENTRY}', $dbstatusmsg_admin,$message);
				$message=str_ireplace('{FULLIPN}', $this->fullipn,$message);
				
				UtilityHelper::send_mail($admin_email, $subject, $message);
				
				
				
					$res1=$db->execute_query("select * from ".TABLE_PREFIX."emailtemplates where id=6");
					$row1=$res1->fetch_assoc();
					$sub=$row1['sub'];
					$message=$row1['body'];
					if($row1[$locale.'_sub']!='')
						$sub=$row1[$locale.'_sub'];
					if($row1[$locale.'_body']!='')
						$message=$row1[$locale.'_body'];
					
			
				
				$message=str_ireplace("{AMT}", $payment_amount.$payment_currency,$message);
				$message=str_ireplace("{USERNAME}", $this->get_user_name($userid),$message);
				$message=str_ireplace("{ITEMNAME}", $item_name,$message);
				$message=str_ireplace("{PAYMENTFOR}", $paymentname,$message);
				
				$message=str_ireplace("{TXNID}", $txn_id,$message);
				
				$message=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$message);
				$sub=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$sub);
				
				UtilityHelper::send_mail($uname, $sub, $message);
				die;
 			}
 			}
		
	

	function log_trans($ecode)
	{
		$db= DBLayer::get_instance();
		
		
		$item_name = $this->read_post_param('item_name');
		$item_number = $this->read_post_param('item_number');
		$payment_status = $this->read_post_param('payment_status');
		$payment_amount = $this->read_post_param('mc_gross');
		$payment_currency =$this->read_post_param('mc_currency');
		$txn_id = $this->read_post_param('txn_id');
		$receiver_email = $this->read_post_param('business');
		$payer_email = $this->read_post_param('payer_email');
		$txn_type = $this->read_post_param('txn_type');
		$pending_reason = $this->read_post_param('pending_reason');
		$payment_type = $this->read_post_param('payment_type');
		$userid1 =$this-> read_post_param('custom');
		$fee=$this-> read_post_param('payment_fee');

		$single=explode("_",$userid1);
		$userid=$single[0];

		$planid=$single[1];
		$home_listing1=intval($single[2]);
		$paid_listing=intval($single[3]);
		
		
		
		
		
		$premium_enabled=Settings::get_instance()->read('enable_premium_listing');
		$home_enabled=Settings::get_instance()->read('home_page_listing');
		
		if($planid =='a' || $premium_enabled ==0)
		$premium_listing=0;
		else
		$premium_listing=1;
		
		if($home_enabled ==1 && $home_listing1 ==1)
		$home_listing=1;
		else
		$home_listing=0;
		
		$plist='';
		$namestring='';
		
		

		
		if($paid_listing ==1)
		$plist.='1';
		else
		$plist.='0';
		
		if($plist !="")
		$plist.='_';
		
		if($premium_listing ==1)
		$plist.='1';
		else
		$plist.='0';	

		if($plist !="")
		$plist.='_';		
		
		if($home_listing ==1)
		$plist.='1';
		else
		$plist.='0';		
		
		
		
		if($paid_listing ==1)
		$namestring.=$this->get_label('paid posting');
						
		
		if($premium_listing ==1)
		{
			if($namestring !='')
			$namestring.=' , ';
			
			$namestring.=$this->get_label('premium listing');
		}
		
		if($home_listing ==1)
		{
			if($namestring !='')
			$namestring.=' , ';
			
			$namestring.=$this->get_label('home listing');
			
		}
			
		
		$paymentname=$namestring;
		
		
		
		
		
		$result = ($ecode=="Success"?1:0);

		if($ecode=="Success")
		{
			$res1=$db->execute_query("INSERT INTO ".TABLE_PREFIX."payment_summary (uid,amount,payment_type,date,payment,itemid,payment_list) values (?,?,?,?,?,?,?)",array($userid,$payment_amount,1,time(),2,$item_number,$plist));
			$paymentid=$res1->get_last_id();
				
			$sql="INSERT INTO ".TABLE_PREFIX."paypal_ipn (payment_id,txnid,userid,result,resultdetails,amount,currency,payeremail,
			receiveremail,paymenttype,status,pendingreason,receivedate,fee) values	(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			$reslt=$db->execute_query($sql,array($paymentid,$txn_id,$userid,$result,$ecode,$payment_amount,$payment_currency,$payer_email,
			$receiver_email,$txn_type,$payment_status,$pending_reason,time(),$fee));
			return $reslt->get_last_id();
		}
		else // all paypal failure cases
		{
			if($userid!="")
			{
				$uname=$this->get_user_name($userid);
				$admin_email=Settings::get_instance()->read('general_notification_email');

				$res1=$db->execute_query("select sub,body from ".TABLE_PREFIX."emailtemplates where id=7");
				$result1=$res1->fetch_assoc();
				
				$subject=$result1['sub'];
				$message=$result1['body'];
				

				$message=str_ireplace("{AMT}", $payment_amount.$payment_currency,$message);
				$message=str_ireplace("{USERNAME}", $this->get_user_name($userid),$message);
				$message=str_ireplace("{ITEMNAME}", $item_name,$message);
				$message=str_ireplace("{PAYMENTFOR}", $paymentname,$message);
				
				
				
				$message=str_ireplace("{TXNID}", $txn_id,$message);
				$message=str_ireplace('{FULLIPN}', $this->fullipn,$message);
				$message=str_ireplace('{ERROR}', $ecode, $message);
				
				$message=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$message);
				$subject=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$subject);

				UtilityHelper::send_mail($admin_email, $subject, $message);
				$locale=$db->read_single_column("select locale from ".TABLE_PREFIX."users where id=?",array($userid));

			
					$res1=$db->execute_query("select * from ".TABLE_PREFIX."emailtemplates where id=8");
					$row1=$res1->fetch_assoc();
					$subject=$row1['sub'];
					$message=$row1['body'];
					if($row1[$locale.'_sub']!='')
						$subject=$row1[$locale.'_sub'];
					if($row1[$locale.'_body']!='')
						$message=$row1[$locale.'_body'];
				

				$message=str_ireplace("{AMT}", $payment_amount.$payment_currency,$message);
				$message=str_ireplace("{USERNAME}", $this->get_user_name($userid),$message);
				$message=str_ireplace("{ITEMNAME}", $item_name,$message);
				$message=str_ireplace("{PAYMENTFOR}", $paymentname,$message);
				
				$message=str_ireplace("{TXNID}", $txn_id,$message);
				
				$subject=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$subject);
				$message=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$message);
				UtilityHelper::send_mail($uname, $subject, $message);
			}
		}
	}

	function array2str($kvsep, $entrysep, $a)
	{
		$str = "";
		if(is_array($a))
		{
			foreach ($a as $k=>$v)
			{
				$str .= "{$k}{$kvsep}{$v}{$entrysep}";
			}
		}
		return $str;
	}

		
	function paypal_success_action()
	{
        $this->set_title($this->get_label('paypal success'));
        $item_name = "";
        $item_number = "";
        $payment_status = "";
        $payment_amount = '';
        $payment_currency ='';
        $txn_id = '';
        $receiver_email = '';
        $txn_type = '';
        $pending_reason = '';
        $payment_type = '';
        $userid ='';
        $fee='';
        $pp_hostname = "www.paypal.com";
        //$pp_hostname = "www.sandbox.paypal.com";
        // read the post from PayPal system and add 'cmd'
        $req = 'cmd=_notify-synch';
        $tx_token = $_GET['tx'];
        $keyarray = array();
        if($tx_token!='')
		{
            $auth_token=Settings::get_instance()->read('paypal_token_id');
            if($auth_token!='')
            {
                $req .= "&tx=$tx_token&at=$auth_token";
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, "https://$pp_hostname/cgi-bin/webscr");
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $req);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
                //set cacert.pem verisign certificate path in curl using 'CURLOPT_CAINFO' field here,
                //if your server does not bundled with default verisign certificates.
                curl_setopt($ch, CURLOPT_CAINFO, LIB_DIR_PATH.'paypal-cert/cacert.pem');
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array("Host: $pp_hostname"));
                $res = curl_exec($ch);
                curl_close($ch);
                if($res){
                    $lines = explode("\n", trim($res));
                    if (strcmp ($lines[0], "SUCCESS") == 0) {
                        for ($i = 1; $i < count($lines); $i++) {
                            $temp = explode("=", $lines[$i],2);
                            $keyarray[urldecode($temp[0])] = urldecode($temp[1]);
                        }
                    }
                    else if (strcmp ($lines[0], "FAIL") == 0) {
                        $this->set_notice("unable to verify paypal transaction");
                    }
                }
            }
        }
        else
        {
            header("Location: ".$this->make_base_url("user/home"));
			exit;
		}
        if(count($keyarray)>0)
        {
            $item_name = $keyarray['item_name'];
            $item_number = $keyarray['item_number'];
            $payment_status = $keyarray['payment_status'];
            $payment_amount = $keyarray['mc_gross'];
            $payment_currency =$keyarray['mc_currency'];
            $txn_id = $keyarray['txn_id'];
            $receiver_email = $keyarray['business'];
            $payer_email = $keyarray['payer_email'];
            $txn_type = $keyarray['txn_type'];
            if(isset($keyarray['pending_reason']))
                $pending_reason = $keyarray['pending_reason'];
                $payment_type = $keyarray['payment_type'];
                $userid =$keyarray['custom'];
                $fee=$keyarray['payment_fee'];
        }
        else if(isset($_GET['item_name']) && isset($_GET['item_number']) && isset($_GET['st']) && isset($_GET['amt']) && isset($_GET['cc']) && isset($_GET['cm']) && isset($_GET['tx']))
        {
            $item_name = $_GET['item_name'];
            $item_number = $_GET['item_number'];
            $payment_status = $_GET['st'];
            $payment_amount = $_GET['amt'];
            $payment_currency =$_GET['cc'];
            $userid =$_GET['cm'];
            $txn_id = $_GET['tx'];
        }
		$this->set_variable('item_name', $item_name);
		$this->set_variable('item_number',$item_number);
		$this->set_variable('payment_status', $payment_status);
		$this->set_variable('payment_amount', $payment_amount);
		$this->set_variable('payment_currency', $payment_currency);
		$this->set_variable('txn_id',$txn_id);
		$this->set_variable('receiver_email', $receiver_email);
		$this->set_variable('payer_email', $payer_email);
		$this->set_variable('userid', $userid);
		$this->set_variable('fee', $fee);
		$this->set_variable('pending_reason', $pending_reason);


	}

	
	function cancel_action()
	{
		$this->flash($this->get_message('cancelled the payment'), BASE);
		die;
	}
	
	
	function details_action()
	{
		$this->set_title($this->get_label('payment details'));
		$db= DBLayer::get_instance();
		$paymentid=$this->read_page_param(1);
		$uid=$this->read_cookie_param(COOKIE_LOGINID);
		
		if(!$this->get_payment_exists($paymentid,$uid))
		{
			$this->flash($this->get_message('invalid id'), $this->make_base_url('user/home'),0);
			exit;
		}
		
		$res=$db->execute_query("select * from ".TABLE_PREFIX."paypal_ipn where payment_id=? ORDER BY id desc",array($paymentid));
		$this->set_result('res', $res);
		
		
		
		
		$payment=$db->read_single_column("SELECT payment FROM ".TABLE_PREFIX."payment_summary WHERE id=?",array($paymentid));
		if($payment ==2)
		{
			$listingid=$db->read_single_column("SELECT itemid FROM ".TABLE_PREFIX."payment_summary WHERE id=?",array($paymentid));
			$paymentlist=$db->read_single_column("SELECT payment_list FROM ".TABLE_PREFIX."payment_summary WHERE id=?",array($paymentid));
			$paymentlist123=$this->get_payment_list($paymentlist,1);
			
			$this->set_variable('listingid',$listingid);
			$this->set_variable('listingname',$this->get_item_title($listingid));
			$this->set_variable('paymentlist123',$paymentlist123);
		}
		$this->set_variable('payment',$payment);
		
	}
	
	
	function member_paypal_ipn_action()
	{
        $verify_url = "https://ipnpb.paypal.com/cgi-bin/webscr";
        // $verify_url = 'https://ipnpb.sandbox.paypal.com/cgi-bin/webscr';
        $raw_post_data = file_get_contents('php://input');
        $raw_post_array = explode('&', $raw_post_data);
        $myPost = array();
        foreach ($raw_post_array as $keyval) {
            $keyval = explode('=', $keyval);
            if (count($keyval) == 2) {
                // Since we do not want the plus in the datetime string to be encoded to a space, we manually encode it.
                if ($keyval[0] === 'payment_date') {
                    if (substr_count($keyval[1], '+') === 1) {
                        $keyval[1] = str_replace('+', '%2B', $keyval[1]);
                    }
                }
                $myPost[$keyval[0]] = urldecode($keyval[1]);
            }
        }
        
        // Build the body of the verification post request, adding the _notify-validate command.
		$req = 'cmd=_notify-validate';
        $get_magic_quotes_exists = false;
        if (function_exists('get_magic_quotes_gpc')) {
            $get_magic_quotes_exists = true;
        }
        foreach ($myPost as $key => $value) {
            if ($get_magic_quotes_exists == true && get_magic_quotes_gpc() == 1) {
                $value = urlencode(stripslashes($value));
            } else {
                $value = urlencode($value);
            }
            $req .= "&$key=$value";
		}
        // Post the data back to PayPal, using curl. Throw exceptions if errors occur.
	
        
        $ch = curl_init($verify_url);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $req);
        curl_setopt($ch, CURLOPT_SSLVERSION, 6);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        // This is often required if the server is missing a global cert bundle, or is using an outdated one.
        curl_setopt($ch, CURLOPT_CAINFO, LIB_DIR_PATH.'paypal-cert/cacert.pem');
        curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Connection: Close'));
        $res = curl_exec($ch);
        if ( ! ($res)) {
            $errno = curl_errno($ch);
            $errstr = curl_error($ch);
            curl_close($ch);
            $this->member_log_trans("cURL error: [$errno] $errstr");
            die;
        }
        $info = curl_getinfo($ch);
        
        $http_code = $info['http_code'];
        if ($http_code != 200) {
            $this->member_log_trans("PayPal responded with http code $http_code");
            die;
        }
        curl_close($ch);
		// Assign posted variables to local variables
		$item_name = $this->read_post_param('item_name');
		$item_number = $this->read_post_param('item_number');
		$payment_status = $this->read_post_param('payment_status');
		$payment_amount = $this->read_post_param('mc_gross');
		$payment_currency =$this->read_post_param('mc_currency');
		$txn_id = $this->read_post_param('txn_id');
		$receiver_email = $this->read_post_param('business');
		$payer_email = $this->read_post_param('payer_email');
		$txn_type = $this->read_post_param('txn_type');
		$pending_reason = $this->read_post_param('pending_reason');
		$payment_type = $this->read_post_param('payment_type');
		$userid =$this-> read_post_param('custom');
		$fee=$this-> read_post_param('payment_fee');
	
		$db= DBLayer::get_instance();
		// Check parameters
	
	
		$uname=$this->get_user_name($userid);
		$admin_email=Settings::get_instance()->read('general_notification_email');
	
	
	
        // Check parameters
        if (!$info)
		{
			// HTTP error
            $this->member_log_trans("HTTP Error, can't connect to Paypal");
			die;
		}
		else
		{
			$ret = "";
            
            
            
	
            
            
	
	
				// check that receiver_email is your Primary PayPal email
				$paypal_email=Settings::get_instance()->read('paypal_email');
				if(strcasecmp($receiver_email,$paypal_email) !=0)
				{
					$this->member_log_trans("Wrong Receiver Email - $item_number");
					die;
				}
	
	
				// check that txn_id has not been previously processed
				$sql = "SELECT txnid FROM ".TABLE_PREFIX."paypal_ipn WHERE txnid = '$txn_id' AND result = '1'";
				$res1=$db->execute_query($sql);
				$val=$res1->fetch_assoc();
				if($val['txnid']!="")
				{
					// Entry present
					$this->member_log_trans("Invalid/Duplicate Transaction - $txn_id");
					die;
				}
	
	
	
	
				if(!$this->get_active_membership_plan($item_number))
				{
					$this->member_log_trans("Invalid Membership Plan Id.");
					die;
				}
	
				$planamount=$db->read_single_column("select rate from ".TABLE_PREFIX."membershipplans where id=?",array($item_number));
	
	
				if($payment_amount < $planamount)
				{
					$this->member_log_trans("Payment amount is less than actual amount.");
					die;
				}
	
				$paypal_currency=Settings::get_instance()->read('paypal_currency');
				if ($payment_currency != $paypal_currency)
				{
					$this->member_log_trans("Wrong Currency - Received: $payment_currency; Expected: $paypal_currency");
					die;
				}
	
	
				// check the payment_status is Completed
				if ($payment_status != "Completed")
				{
					$this->member_log_trans("Incomplete Payment - Payment Status: $payment_status");
					die;
				}
	
	
				$db->execute_query("begin");
				$error_flag=0;
	
				$payment_id=$this->member_log_trans("Success");
				if($payment_id >0)
				{
					$days=$db->read_single_column("SELECT days from ".TABLE_PREFIX."membershipplans where id=?",array($item_number));
	
					$oldexpiry=$db->read_single_column("SELECT plan_expiry from ".TABLE_PREFIX."users WHERE id=?",array($userid));
	
	
					$t=time();
					
					if($oldexpiry >0)
					$expiry=gmmktime(gmdate("H",$oldexpiry),gmdate("i",$oldexpiry),gmdate("s",$oldexpiry),gmdate("m",$oldexpiry),gmdate("d",$oldexpiry)+$days,gmdate("Y",$oldexpiry));
					else
					$expiry=gmmktime(gmdate("H",$t),gmdate("i",$t),gmdate("s",$t),gmdate("m",$t),gmdate("d",$t)+$days,gmdate("Y",$t));
					
					
					
					
					if($oldexpiry > $expiry)
					$expiry=$oldexpiry;
	
	
					$result=$db->execute_query("UPDATE ".TABLE_PREFIX."users set plan_expiry=? where id=?",array($expiry,$userid));
					if($result->get_error() !="")
					$error_flag=1;
					else 
					{
						
						
						
						
						
						/////////////////////////////////////////////////////////////////////////////
						
						$default_status=Settings::get_instance()->read('default_item_status');	
						$adexpiry=Settings::get_instance()->read("ad_expiry");
						
						$listrow=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."items WHERE status=-3 AND user=?",array($userid));
						
						while($listdata=$listrow->fetch_assoc())
						{
							$paid_array=$this->get_paid_option($listdata['category'],$userid);
							$paid_array_data=explode('-',$paid_array);
						
							$paid_listing=intval($paid_array_data[1]);		
									
							
							if($paid_listing ==1)
							{
								if($default_status !=1)
								$update=$db->execute_query("UPDATE ".TABLE_PREFIX."items SET status=? WHERE id=? AND user=?",array($default_status,$listdata['id'],$userid));
								else
								{
									$time_arr=getdate(time());
									$gmtime=gmmktime($time_arr['hours'],$time_arr['minutes'],$time_arr['seconds'],$time_arr['mon'],$time_arr['mday']+$adexpiry,$time_arr['year']);
										
									$update=$db->execute_query("UPDATE ".TABLE_PREFIX."items SET status=?,expiry_time=? WHERE id=? AND user=?",array($default_status,$gmtime,$listdata['id'],$userid));
								}
								
								
								if($update->get_error() !="")
								{
									$error_flag=2;
									break;
								}
							}
						}
						/////////////////////////////////////////////////////////////////////////
						
						
						

						
						
						$db->execute_query("DELETE FROM ".TABLE_PREFIX."notification WHERE uid=? AND type=1",array($userid));
						
					}
						
				}
				else
				{
					$error_flag=1;
				}
	
				$dbstatusmsg_admin='';
				if($error_flag ==1)
				{
					$db->execute_query("rollback");
					$dbstatusmsg_admin='The database entries related to the payment could not be added. Please do it manually';
				}
				else
				{
					$db->execute_query("commit");
					
					
					
					
					
					/////////////////////////////////////////////////////////////////////////////
					if($error_flag ==2)
					$dbstatusmsg_admin='The database entries related to the payment were successfully captured.But listings status updation failed. Please do it manually';
					else
					$dbstatusmsg_admin='The database entries related to the payment were successfully captured.';
					/////////////////////////////////////////////////////////////////////////////
					
					
					
					
				}
	
	
				$res1=$db->execute_query("select sub,body from ".TABLE_PREFIX."emailtemplates where id=5");
				$result1=$res1->fetch_assoc();
				$subject=$result1['sub'];
				$message=$result1['body'];

	
				$message=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$message);
				$subject=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$subject);
				
				$message=str_ireplace("{AMT}", $payment_amount.$payment_currency,$message);
				$message=str_ireplace("{USERNAME}", $this->get_user_name($userid),$message);
				$message=str_ireplace("{ITEMNAME}", $item_name,$message);
				$message=str_ireplace("{PAYMENTFOR}", $this->get_label('paid membership'),$message);
				$message=str_ireplace("{TXNID}", $txn_id,$message);
				$message=str_ireplace('{DBENTRY}', $dbstatusmsg_admin,$message);
				$message=str_ireplace('{FULLIPN}', $this->fullipn,$message);
	
				UtilityHelper::send_mail($admin_email, $subject, $message);
	
				$locale=$db->read_single_column("select locale from ".TABLE_PREFIX."users where id=?",array($userid));
	
	
					$res1=$db->execute_query("select * from ".TABLE_PREFIX."emailtemplates where id=6");
					$row1=$res1->fetch_assoc();
					$subject=$row1['sub'];
					$message=$row1['body'];
					if($row1[$locale.'_sub']!='')
						$subject=$row1[$locale.'_sub'];
					if($row1[$locale.'_body']!='')
						$message=$row1[$locale.'_body'];
				
				$message=str_ireplace("{AMT}", $payment_amount.$payment_currency,$message);
				$message=str_ireplace("{USERNAME}", $this->get_user_name($userid),$message);
				$message=str_ireplace("{ITEMNAME}", $item_name,$message);
				$message=str_ireplace("{PAYMENTFOR}", $this->get_label('paid membership'),$message);
				$message=str_ireplace("{TXNID}", $txn_id,$message);
				
				$message=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$message);
				$subject=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$subject);
				
				UtilityHelper::send_mail($uname, $subject, $message);
				die;
	
			}
			}
    
    
	
	
	function member_log_trans($ecode)
	{
		$item_name = $this->read_post_param('item_name');
		$item_number = $this->read_post_param('item_number');
		$payment_status = $this->read_post_param('payment_status');
		$payment_amount = $this->read_post_param('mc_gross');
		$payment_currency =$this->read_post_param('mc_currency');
		$txn_id = $this->read_post_param('txn_id');
		$receiver_email = $this->read_post_param('business');
		$payer_email = $this->read_post_param('payer_email');
		$txn_type = $this->read_post_param('txn_type');
		$pending_reason = $this->read_post_param('pending_reason');
		$payment_type = $this->read_post_param('payment_type');
		$userid =$this-> read_post_param('custom');
		$fee=$this-> read_post_param('payment_fee');
	
	
	
		$t=time();
		$result = ($ecode=="Success"?1:0);
		$db= DBLayer::get_instance();
	
	
		if($ecode=="Success")
		{
			$res1=$db->execute_query("INSERT INTO ".TABLE_PREFIX."payment_summary (uid,amount,payment_type,date,payment) values (?,?,?,?,?)",array($userid,$payment_amount,1,$t,1));
			$paymentid=$res1->get_last_id();
	
	
			$sql="INSERT INTO ".TABLE_PREFIX."paypal_ipn (payment_id,txnid,userid,result,resultdetails,amount,currency,payeremail,
			receiveremail,paymenttype,status,pendingreason,receivedate,fee) values	(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			$reslt=$db->execute_query($sql,array($paymentid,$txn_id,$userid,$result,$ecode,$payment_amount,$payment_currency,$payer_email,
					$receiver_email,$txn_type,$payment_status,$pending_reason,$t,$fee));
			return $reslt->get_last_id();
		}
		else // all paypal failure cases
		{
	
			if($userid!="")
			{
	
				$uname=$this->get_user_name($userid);
				$admin_email=Settings::get_instance()->read('general_notification_email');
	
				$res1=$db->execute_query("select sub,body from ".TABLE_PREFIX."emailtemplates where id=7");
				$result1=$res1->fetch_assoc();
				
				$subject=$result1['sub'];
				$message=$result1['body'];
				
	
	
				$message=str_ireplace("{AMT}", $payment_amount.$payment_currency,$message);
				$message=str_ireplace("{USERNAME}", $this->get_user_name($userid),$message);
				$message=str_ireplace("{ITEMNAME}", $item_name,$message);
				$message=str_ireplace("{PAYMENTFOR}", $this->get_label('paid membership'),$message);
				$message=str_ireplace("{TXNID}", $txn_id,$message);
				$message=str_ireplace('{FULLIPN}', $this->fullipn,$message);
				$message=str_ireplace('{ERROR}', $ecode, $message);
				
				$message=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$message);
				$subject=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$subject);
	
				UtilityHelper::send_mail($admin_email, $subject, $message);
	
	
				$res1=$db->execute_query("select * from ".TABLE_PREFIX."emailtemplates where id=8");
					$row1=$res1->fetch_assoc();
					$subject=$row1['sub'];
					$message=$row1['body'];
					if($row1[$locale.'_sub']!='')
						$subject=$row1[$locale.'_sub'];
					if($row1[$locale.'_body']!='')
						$message=$row1[$locale.'_body'];
	
	
				$message=str_ireplace("{AMT}", $payment_amount.$payment_currency,$message);
				$message=str_ireplace("{USERNAME}", $this->get_user_name($userid),$message);
				$message=str_ireplace("{ITEMNAME}", $item_name,$message);
				$message=str_ireplace("{PAYMENTFOR}", $this->get_label('paid membership'),$message);
				$message=str_ireplace("{TXNID}", $txn_id,$message);
				
				$subject=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$subject);
				$message=str_ireplace("{ENGINE}",Settings::get_instance()->read('engine_name'),$message);
				UtilityHelper::send_mail($uname, $subject, $message);
			}
		}
	}
};
