<?php
include_once COMMON_DIR_PATH.'helpers'.DS."login-helper.php";
include_once COMMON_DIR_PATH.'helpers'.DS."utility-helper.php";
include_once COMMON_DIR_PATH.DS.'helpers'.DS."image-helper.php";
class UserController extends AppController
{
	function before_execute()
	{
		parent::before_execute();
		if($this->get_action()=="home" || $this->get_action()=="change_password" || $this->get_action()=="payments" || $this->get_action()=="membership" || $this->get_action()=="profile" || $this->get_action()=="my_favourites" )
		{
			if(LoginHelper::validate_user_login()==0)
			{
				$this->flash($this->get_message('please login to continue'), $this->make_base_url('user/login_register'),0);
			}
		}
	}

	
	
	function login_register_action()
	{
		$this->set_title($this->get_label('register/login'));
	
		if(LoginHelper::validate_user_login()!=0)
		{
			header("Location:".$this->make_base_url('user/home'));
			exit;
		}
		
		//require_once LIB_DIR_PATH.'recaptchalib.php';
		require_once LIB_DIR_PATH.'recaptcha/autoload.php';
		
		$db= DBLayer::get_instance();
		
		
		$min_pass_len=Settings::get_instance()->read('min_pass_len');
		$this->set_variable("min_pass_len",$min_pass_len);
		
		
		if($_POST)
		{
			$act=$_POST['act'];
			
			if($act ==1)
			{
				$msg="";
				$username=$this->read_post_param('username');
				$password=$this->read_post_param('password');
				
				
				if($username=="" || $password=="")
				{
					$this->set_notice('mandatory');
				}
				else
				{
					$this->set_variable('username',$username);
					$this->set_variable('password',$password);
				
				
					$res=$db->execute_query("select id from ".TABLE_PREFIX."users where email=? and password=?",array($username,md5($password)));
					$value2=$res->fetch_assoc();
					$id=$value2['id'];
					
					$orig_password=$db->read_single_column("select password from ".TABLE_PREFIX."users where email=? and status=1", array($username));
				
				
					if(md5($password)== $orig_password)
					{
						$t=time();
						$res=$db->execute_query("update ".TABLE_PREFIX."users set last_login_time=? where id=?",array($t,$id));
								
						setcookie(COOKIE_LOGINID,$id,0,$this->get_base_path(),$this->get_base_domain());
						setcookie(COOKIE_USERNAME,$username,0,$this->get_base_path(),$this->get_base_domain());
						setcookie(COOKIE_PASSWORD,$orig_password,0,$this->get_base_path(),$this->get_base_domain());
						
						setcookie(COOKIE_SOCIALLOGIN,"",0,$this->get_base_path(),$this->get_base_domain());
						setcookie(COOKIE_SOCIALLOGINEMAIL,"",0,$this->get_base_path(),$this->get_base_domain());
						setcookie(COOKIE_FBLOGINSUCCESS,"",0,$this->get_base_path(),$this->get_base_domain());
						setcookie(COOKIE_GPTOKEN,"",0,$this->get_base_path(),$this->get_base_domain());
				
								
						
						
						$logedowneremail=$this->get_user_email($id);
						

						
						$db->execute_query("update ".TABLE_PREFIX."items set user=? where user=0 AND email=?",array($id,$logedowneremail));
						
						
						
						
						
						////////////////////////////////////////////////////////////////////////////
						
						$adexpiry=Settings::get_instance()->read("ad_expiry");
						$default_status=Settings::get_instance()->read('default_item_status');	
						
						$itemrow=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."items WHERE user=? AND email=? AND status=-3",array($id,$logedowneremail));
						
						while($itemdata=$itemrow->fetch_assoc())
						{
						    $paid_array=$this->get_paid_option($itemdata['category'],$id);
							$paid_array_data=explode('-',$paid_array);
						
							$paid_listing=intval($paid_array_data[1]);		
						    $pay_per_posting=intval($paid_array_data[2]);		
							
							if($paid_listing ==0 && $pay_per_posting ==0)
							{
								if($default_status !=1)
								$update=$db->execute_query("UPDATE ".TABLE_PREFIX."items SET status=? WHERE id=? AND user=?",array($default_status,$itemdata['id'],$id));
								else
								{
									$time_arr=getdate(time());
									$gmtime=gmmktime($time_arr['hours'],$time_arr['minutes'],$time_arr['seconds'],$time_arr['mon'],$time_arr['mday']+$adexpiry,$time_arr['year']);
										
									$update=$db->execute_query("UPDATE ".TABLE_PREFIX."items SET status=?,expiry_time=?,publish_time=? WHERE id=? AND user=?",array($default_status,$gmtime,time(),$itemdata['id'],$id));
								}
							}							
						}
						
						////////////////////////////////////////////////////////////////////////////
						
						
						
						
						
						
						
						header("Location: ".$this->make_base_url("user/home"));
						exit;
					}
					else
					{
						$this->set_notice("login invalid");
					}
				}
			}
			else if($act==2)
			{
				$email=$this->read_post_param('email');
				$pwd=$this->read_post_param('pwd');
				$rpwd=$this->read_post_param('rpwd');
				$plan=intval($this->read_post_param('plans'));
				$terms=$this->read_post_param("terms");
				$user_name=$this->read_post_param("user_name");
				
				if(isset($GLOBALS['locale_id']))
				$locale=$GLOBALS['locale_id'];
				else
				$locale=$db->read_single_column("select id from ".TABLE_PREFIX."locale where name=?",array(DEFAULT_LOCALE));
								
				$this->set_variable("email",$email);
				$this->set_variable("plan",$plan);
				$this->set_variable("terms",$terms);
				
				$this->set_variable("user_name",$user_name);
		
				
								
				$cap_flg=0;
				$captcha_val=0;
				if(Settings::get_instance()->read('enable_captcha_verification')==1)
				{
				    
				    $cap_flg=1;
				    $recaptcha_private_key = Settings::get_instance()->read('recaptcha_private_key');
				    if ($_POST["g-token"] !="")
				    {
				        $captcha = $this->read_post_param('g-token');
				        $captcha_val=$this->validate_captcha($captcha);
				        
				    }
				}
				
				if($user_name=="" || $email=="" || $pwd=="" || $rpwd=="")
				{
					$this->set_notice("mandatory");
				}
				
				else if($exists >0)
				{
					$this->set_notice("id unavailable");
				}
				elseif(!UtilityHelper::is_valid_email($email))
				{
					$this->set_notice("email format");
				}
				elseif((strlen($pwd) < $min_pass_len) || (strlen($rpwd) < $min_pass_len))
				{
					$this->set_notice("password length");
				}
				elseif($pwd!=$rpwd)
				{
					$this->set_notice("password mismatch");
				}
				elseif($terms !=1)
				{
					$this->set_notice("terms condition agree");
				}
				
				else if(Settings::get_instance()->read('enable_captcha_verification')==1 && $captcha_val !=1)
				{
				
				$this->set_notice("check image verification");
				}
				else
				{
				  
				
				    
				    if($cap_flg==1 && $captcha_val !=1 && Settings::get_instance()->read('enable_captcha_verification')==1)
					{
						$this->set_notice("check image verification");
					}
					else
					{
						$id=$db->read_single_column("SELECT id FROM ".TABLE_PREFIX."users WHERE email=? AND registration_type=1",array($email));
						$id=intval($id);
						
						if($id >0)
						{
							$res=$db->execute_query("UPDATE ".TABLE_PREFIX."users SET email=?,password=?,status=?,reg_time=?,last_login_time=?,registration_type=?,user_name=? WHERE id=?",array($email,md5($pwd),-2,time(),time(),0,$user_name,$id));
						}
						else
						{
							$res=$db->execute_query("INSERT INTO ".TABLE_PREFIX."users (`email`,`password`,`status`,`reg_time`,`last_login_time`,`locale`,`user_name`) values (?,?,?,?,?,?,?)",array($email,md5($pwd),-2,time(),time(),$locale,$user_name));
							$id=$res->get_last_id();
							
							
							$b=$db->execute_query("INSERT INTO ".TABLE_PREFIX."notification (`uid`,`itemid`,`type`,`expiry`,`readed`) VALUES (?,?,?,?,?)",array($id,$plan,1,0,0));
							
						}
						
						
						$confirmurl=BASE."index.php?page=user/confirm_email/".$id."/".$this->mybase64_encode($email)."/".md5($id.$email)."/".$plan;
						$res1=$db->execute_query("select * from ".TABLE_PREFIX."emailtemplates where id=10");
						$row1=$res1->fetch_assoc();
						$subject=$row1['sub'];
						$message=$row1['body'];
						if($row1[$locale.'_sub']!='')
							$subject=$row1[$locale.'_sub'];
						if($row1[$locale.'_body']!='')
							$message=$row1[$locale.'_body'];
						
						
						$subject=str_ireplace('{ENGINE}', Settings::get_instance()->read('engine_name'),$subject);
						$message=str_ireplace('{ENGINE}', Settings::get_instance()->read('engine_name'),$message);
						$message=str_ireplace('{CONFIRMURL}', $confirmurl,$message);
						
						UtilityHelper::send_mail($email,$subject,$message);
						
						
						$this->flash($this->get_message('registration success'),BASE);
						exit;
					}
				}
			}
		}
		
		
		
	
	
		$recaptcha_public_key=Settings::get_instance()->read('recaptcha_public_key');
		$this->set_variable('recaptcha_public_key',$recaptcha_public_key);
	
	
	

		
		if(!$_POST)
		{
			$email="";
			$plan="";
			$terms="";
			$item_id="";
			$premium="";
			$username="";
			
			$this->set_variable("username",$username);
			$this->set_variable("terms",$terms);
			$this->set_variable('item_id', $item_id);
			$this->set_variable('premium', $premium);
			$this->set_variable("email",$email);
			$this->set_variable("plan",$plan);
			
			if(DEMO_MODE)
			{
				$username=$db->read_single_column("select email from ".TABLE_PREFIX."users where id=1");
				$password="demo";
			
				$this->set_variable('username',$username);
				$this->set_variable('password',$password);
			}
		
		}
		
		
		
		if($this->read_page_param(1)=="expired")
		{
			$msg= "login exp";
			$this->set_notice($msg,1);
		}
		else if($this->read_page_param(1)=="l")
		{
			$msg="logout";
			$this->set_notice($msg,1);
		}
		
		
	}

	
	
	function confirm_email_action()
	{
		$uid=$this->read_page_param(1);
		$email=$this->mybase64_decode($this->read_page_param(2));
		$mdvalue=$this->read_page_param(3);
		$plan=$this->read_page_param(4);
		$set_time=0;
	
		if($plan=="" || $plan <0)
		$plan=0;
	
		$mdvalue_new=md5($uid.$email);
	
		if($mdvalue_new != $mdvalue)
		{
			$this->flash($this->get_message('invalid operation'),BASE);
			exit;
		}
		else
		{
			$db= DBLayer::get_instance();
	
			$res=$db->execute_query("select email,status,password from ".TABLE_PREFIX."users where id=?",array($uid));
			$result=$res->fetch_assoc();
			$email=$result['email'];
			$status=$result['status'];
			$password=$result['password'];
			

	
			if($status==-2)
			{
				$res=$db->execute_query("update ".TABLE_PREFIX."users set status=? where id=?",array(1,$uid));
				
				setcookie(COOKIE_LOGINID,$uid,0,$this->get_base_path(),$this->get_base_domain());
				setcookie(COOKIE_USERNAME,$email,0,$this->get_base_path(),$this->get_base_domain());
				setcookie(COOKIE_PASSWORD,$password,0,$this->get_base_path(),$this->get_base_domain());
				
				setcookie(COOKIE_SOCIALLOGIN,"",0,$this->get_base_path(),$this->get_base_domain());
				setcookie(COOKIE_SOCIALLOGINEMAIL,"",0,$this->get_base_path(),$this->get_base_domain());
				setcookie(COOKIE_FBLOGINSUCCESS,"",0,$this->get_base_path(),$this->get_base_domain());
				setcookie(COOKIE_GPTOKEN,"",0,$this->get_base_path(),$this->get_base_domain());
				
								
				$res1=$db->execute_query("select sub,body from ".TABLE_PREFIX."emailtemplates where id=4");
				$result1=$res1->fetch_assoc();
				
				$subject=$result1['sub'];
				$message=$result1['body'];
				
				$message=str_ireplace("{ENGINE}", Settings::get_instance()->read('engine_name'),$message);
				$subject=str_ireplace("{ENGINE}", Settings::get_instance()->read('engine_name'),$subject);
				
				$message=str_ireplace("{PASSWORD}",'xxxxxx',$message);
				
				$message=str_ireplace("{EMAIL}", $email,$message);
				
				UtilityHelper::send_mail($email, $subject, $message);
				
				
				
				$logedowneremail=$this->get_user_email($uid);
				

				
				$db->execute_query("update ".TABLE_PREFIX."items set user=? where user=0 AND email=?",array($uid,$logedowneremail));
				
				
				
				////////////////////////////////////////////////////////////////////////////
				
				$adexpiry=Settings::get_instance()->read("ad_expiry");
				$default_status=Settings::get_instance()->read('default_item_status');	
				
				$itemrow=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."items WHERE user=? AND email=? AND status=-3",array($uid,$logedowneremail));
				
				while($itemdata=$itemrow->fetch_assoc())
				{
				    $paid_array=$this->get_paid_option($itemdata['category'],$uid);
					$paid_array_data=explode('-',$paid_array);
				
					$paid_listing=intval($paid_array_data[1]);		
					$pay_per_posting=intval($paid_array_data[2]);		
					
					if($paid_listing ==0 && $pay_per_posting ==0)
					{
						if($default_status !=1)
						$db->execute_query("UPDATE ".TABLE_PREFIX."items SET status=? WHERE id=? AND user=?",array($default_status,$itemdata['id'],$uid));
						else
						{
							$time_arr=getdate(time());
							$gmtime=gmmktime($time_arr['hours'],$time_arr['minutes'],$time_arr['seconds'],$time_arr['mon'],$time_arr['mday']+$adexpiry,$time_arr['year']);
								
							$db->execute_query("UPDATE ".TABLE_PREFIX."items SET status=?,expiry_time=?,publish_time=? WHERE id=? AND user=?",array($default_status,$gmtime,time(),$itemdata['id'],$uid));
						}
					}							
				}
				
				////////////////////////////////////////////////////////////////////////////				
				

				
				
				
				
				if($plan >0)
				$this->flash($this->get_message('reg success'), $this->make_base_url('user/membership/'.$plan));
				else
				$this->flash($this->get_message('reg success'), $this->make_base_url('user/home'));
				
				exit;
			}
			else
			{
				$this->flash($this->get_message('invalid operation'),BASE,0);
				exit;
			}
		}
	}
	
	
	function logout_action()
	{
		if(Settings::get_instance()->read('gp_login_enabled') ==1 && Settings::get_instance()->read('google_client_id') !="" && Settings::get_instance()->read('google_client_secret') !="" && Settings::get_instance()->read('google_developer_key') !="" && $_COOKIE[COOKIE_SOCIALLOGIN]=="gp")
		{
			if(!isset($_SESSION)) 
			{
				session_start();
			}
		
			$gClient = new Google_Client();
			$gClient->setApplicationName('Google App');
			$gClient->setClientId(Settings::get_instance()->read('google_client_id'));
			$gClient->setClientSecret(Settings::get_instance()->read('google_client_secret'));
			$gClient->setRedirectUri($this->make_base_url("layout/googlelogin"));
			$gClient->setDeveloperKey(Settings::get_instance()->read('google_developer_key'));
		
		
			if(isset($_SESSION['token']))
			$gClient->setAccessToken($_SESSION['token']);
		
			unset($_SESSION['token']);
			$gClient->revokeToken();
			
	
		}
		if(Settings::get_instance()->read('fb_login_enabled') ==1 && $_COOKIE[COOKIE_SOCIALLOGIN]=="fb" && Settings::get_instance()->read('fb_app_id') !="" && Settings::get_instance()->read('fb_secret') !="")
		{
			if(!isset($_SESSION))
			{
				session_start();
			}
		
			if(isset($_SESSION['facebook_access_token']))
			unset($_SESSION['facebook_access_token']);
		}

		setcookie(COOKIE_SOCIALLOGIN,"",0,$this->get_base_path(),$this->get_base_domain());
		setcookie(COOKIE_SOCIALLOGINEMAIL,"",0,$this->get_base_path(),$this->get_base_domain());
		setcookie(COOKIE_FBLOGINSUCCESS,"",0,$this->get_base_path(),$this->get_base_domain());
		setcookie(COOKIE_GPTOKEN,"",0,$this->get_base_path(),$this->get_base_domain());
		setcookie(COOKIE_LOGINID,"",0,$this->get_base_path(),$this->get_base_domain());
		setcookie(COOKIE_USERNAME,"",0,$this->get_base_path(),$this->get_base_domain());
		setcookie(COOKIE_PASSWORD,"",0,$this->get_base_path(),$this->get_base_domain());
		setcookie(COOKIE_LOCATION,"",0,$this->get_base_path(),$this->get_base_domain());
		
		header("Location: ".$this->make_base_url("user/login_register/l"));
		die;
	}
	
	
	
	function user_check_action()
	{
		//sleep(2);
		$db= DBLayer::get_instance();
		$username=$this->read_page_param(1);
		
		
		if(UtilityHelper::is_valid_email($username))
		{
			$res=$db->execute_query("select id from ".TABLE_PREFIX."users where email=? and registration_type=0",array($username));
			$value=$res->get_num_records();
		}
		else
			$value=-1;
		
		
		
	
		if($value ==0)
		echo '<span  style="color:green">'.$this->get_message("user available").'</span>';
		else if($value ==-1)
		echo $this->get_message("email format");
		else
		echo $this->get_message("user unavailable");
	
		exit;
	}
	function home_action()
	{
		$this->set_title($this->get_label('user home'));
		$db= DBLayer::get_instance();
		$user=$this->read_cookie_param(COOKIE_LOGINID);
	
		
	
		if($_POST)
		{
			$type=$this->read_post_param("type");
			$status=$this->read_post_param("status");
			$featured=$this->read_post_param("featured");
			$categ=$this->read_post_param("catid");
			$pg="";
		
		}
		else
		{
			$type=$this->read_page_param(1);
			$status=$this->read_page_param(2);
			$featured=$this->read_page_param(3);
			$categ=$this->read_page_param(4);
			$pg=$this->read_page_param(5);
		}
		

		$exp=explode("-",$type);
		if($exp[0]=="page")
		$type=-1;
		
		
		$type_str="";
		$status_str="";
		$featured_str="";
		$cat_str="";
		
		
		$pgnew=explode("-",$pg);
		if($pgnew[0] !="page")
		$pg="";
		
		if($pg=="")
		$pg="page-1";
		
		if($type =="")
		$type=-1;
		
		if($status =="")
		$status=-2;
		
		if($featured =="")
		$featured=-1;
		
		if($categ =="")
		$categ=0;
		
		
		
		$this->set_variable("type",$type);
		$this->set_variable("status",$status);
		$this->set_variable("featured",$featured);
		$this->set_variable("categ",$categ);
		
		$this->set_variable("pg",$pg);
	
	
	
		if($type !=-1)
		$type_str=" and i.type='".$type."' ";
		
		if($status !=-2)
		$status_str=" and i.status='".$status."' ";
		
		
		
		if($featured !=-1)
		{
			if($featured==0)
			$featured_str=" and i.featured=0 ";
			else if($featured==1)
			$featured_str=" and i.featured=1 ";
			else if($featured==2)
			$featured_str=" and i.home_listing=1 ";
			else if($featured==3)
			$featured_str="and i.featured=0 and i.home_listing=1 ";
			else if($featured==4)
			$featured_str="and i.featured=1 and i.home_listing=1 ";
		}
		
		
		
		
		$astr="";
		if($categ !=0)
		{
			//$cat_str=" and category='".$categ."' ";
		
			$childs=$this->display_childs($categ);
			$childs=substr($childs,0,-1);
		
		
		
			$astr="";
		
			if($childs !="")
			{
				$cudata_arr=explode("_",$childs);
		
				if(count($cudata_arr) >0)
				{
					for($k=0;$k< count($cudata_arr); $k++)
					{
					$astr.=" ,$cudata_arr[$k] ";
			}
		}
		}
		
		
		
		$astr='and i.category IN ('.$categ.$astr.') ';
		}
		
	//	$sql="select * from ".TABLE_PREFIX."items where user=? ".$astr.$type_str.$status_str.$featured_str." order by update_time desc";
		
		$sql="select i.* from ".TABLE_PREFIX."items i INNER JOIN ".TABLE_PREFIX."categories c on i.category=c.id and i.user=? and c.status=1 ".$astr.$type_str.$status_str.$featured_str." order by i.update_time desc";

		$pagination = new Pagination($sql,array($user));
		$res=$pagination->get_result();
		$this->set_result("res",$res);
		$this->set_variable("pagination",$pagination->links(),0);
		
		
		$pg=$pagination->get_page_number();
		$this->set_variable("pg","page-".$pg);
		
		
		
		
		$localname='';
		if(isset($_COOKIE['my_locale']))
		$localname=$_COOKIE['my_locale'];
		
		
		
		if(Settings::get_instance()->read('language_enabled') ==1)
		$localeid=intval($this->get_locale_id($localname));
		else
		$localeid=0;
		
		
		
		
		
		
		
		
		$categories="<option value='0'>".$this->get_label('select')."</option>";
		$categories.=$this->get_category_display(0,0,$categ,$localeid);
		$this->set_variable("categories",$categories,0);
		
		
		
	
	
	}
	
	function payments_action()
	{
		$this->set_title($this->get_label('payment details'));
		$db=DBLayer::get_instance();
	
		$payuid=$this->read_cookie_param(COOKIE_LOGINID);
		$type=$this->read_post_param("type");
		
		$type_str="";
		
		if($type =="")
		$type=0;
		
		
		if($type ==1)
		$type_str= " AND payment=1 ";
		else if($type ==2)
		$type_str= " AND payment=2 ";
	
	
		$payquery = "select * from ".TABLE_PREFIX."payment_summary where uid=? ".$type_str." ORDER BY id desc";
		$paypagination = new Pagination($payquery,array($payuid));
		$payres=$paypagination->get_result();
		$this->set_result("payres",$payres);
		$this->set_variable("paypagination",$paypagination->links(),0);
		
		$this->set_variable("type", $type);
		
	
	
	}

	
	
	
	
	
	
	
	

	function membership_action()
	{
		
		$this->set_title($this->get_label('membership payment'));
		
		$plan=intval($this->read_page_param(1));
		$user=$this->read_cookie_param(COOKIE_LOGINID);
		
		if($plan=="")
		$plan=0;
		
		$this->set_variable('plan', $plan);
		$this->set_variable('user', $user);
		
		if(DEMO_MODE==TRUE)
		{
			$this->flash($this->get_message('demo mode'), $this->make_base_url('user/home'),0);
			exit;
		}
		
		$db= DBLayer::get_instance();
		
		if(Settings::get_instance()->read('system_listing_mode')==0)
		{
			$this->flash($this->get_message('invalid operation'), $this->make_base_url('user/home'),0);
			exit;
		}
		

		
		if($plan !=0)
		{
			if(!$this->get_active_membership_plan($plan))
			{
				$this->flash($this->get_message('invalid operation'), $this->make_base_url('user/home'),0);
				exit;
			}
			
			
			$amount=$db->read_single_column("select rate from ".TABLE_PREFIX."membershipplans where id=?",array($plan));
			$this->set_variable('amount', $amount);
		}
		else
		$this->set_variable('amount', "");
	}
	
	

	


	function change_password_action()
	{
		$this->set_title($this->get_label('change password'));

		if(($this->read_cookie_param(COOKIE_SOCIALLOGIN) =="fb" || $this->read_cookie_param(COOKIE_SOCIALLOGIN) =="gp") && (Settings::get_instance()->read('fb_login_enabled') ==1 || Settings::get_instance()->read('gp_login_enabled') ==1))
		{
			$this->flash($this->get_message('invalid operation'),BASE,0);
			exit;
		}
				
		if(!DEMO_MODE || (DEMO_MODE ==TRUE && $this->read_cookie_param(COOKIE_LOGINID) !=1 ))
		{		
				
				$min_pass_len=Settings::get_instance()->read('min_pass_len');
				
				if($_POST)
				{
								
					$current_pwd=$this->read_post_param('current_pwd');
					$pwd=$this->read_post_param('pwd');
					$rpwd=$this->read_post_param('rpwd');
					if($current_pwd=="" || $pwd==""||$rpwd=="")
					{
						$this->set_notice("mandatory");
					}
					elseif(md5($current_pwd)!=DBLayer::get_instance()->read_single_column("select password from ".TABLE_PREFIX."users where email=?", 
							array($this->read_cookie_param(COOKIE_USERNAME))))
					{
						$this->set_notice("password wrong");
					}
					elseif((strlen($pwd)<$min_pass_len) || (strlen($rpwd)<$min_pass_len) )
					{
						$this->set_notice("password length");
					}
					elseif($pwd!=$rpwd)
					{
						$this->set_notice("password mismatch");
					}
					else
					{
						$id=$this->read_cookie_param(COOKIE_LOGINID);
						$db= DBLayer::get_instance();
						
						$res=$db->execute_query("update ".TABLE_PREFIX."users set password=? where id=?",array(md5($pwd),$id));
																	
						setcookie(COOKIE_PASSWORD,md5($pwd),0,$this->get_base_path(),$this->get_base_domain());
						
												
						$this->flash($this->get_message('password resetted'), $this->make_base_url('user/login_register'));
						die;
					}
				
				
				$this->set_variable("pwd",$pwd);
				$this->set_variable("rpwd",$rpwd);
				$this->set_variable("current_pwd",$current_pwd);
				}
				
				$this->set_variable("min_pass_len",$min_pass_len);
				
		}
		else 
		{
			$this->flash($this->get_message('demo mode'), BASE,0);
			exit;
		}		
			
	}

		
	
	function reset_password_action()
	{
		$this->set_title($this->get_label('reset password'));
		
		
		if(($this->read_cookie_param(COOKIE_SOCIALLOGIN) =="fb" || $this->read_cookie_param(COOKIE_SOCIALLOGIN) =="gp") && (Settings::get_instance()->read('fb_login_enabled') ==1 || Settings::get_instance()->read('gp_login_enabled') ==1))
		{
			$this->flash($this->get_message('invalid operation'),BASE,0);
			exit;
		}
		

		$username="";
		
		if($_POST)
		{
			$db= DBLayer::get_instance();
			$username=$this->read_post_param('username');
			
			$demo_id=$db->read_single_column("select id from ".TABLE_PREFIX."users where email=?",array($username));
			
			
			if(!DEMO_MODE || (DEMO_MODE ==TRUE && $demo_id !=1 ))
			{
		
				
						if($username=="")
						{
							$this->set_notice("mandatory");
						}
						else
						{
							
							$res=$db->execute_query("select * from ".TABLE_PREFIX."users where email=?",array($username));
							$result=$res->fetch_assoc();
							
							$email=$result['email'];
							$password=$result['password'];
							$locale=$result['locale'];
				
							if($email=="")
							{
								$this->set_notice("user doesnot exist");
							}
							else
							{
								$newpass=substr($password,0,8);
								$newpassword=md5($newpass);
								
								$up1=$db->execute_query("update ".TABLE_PREFIX."users set password=? where email=?",array($newpassword,$username));
								
							
								$res1=$db->execute_query("select * from ".TABLE_PREFIX."emailtemplates where id=9");
								$row1=$res1->fetch_assoc();
								$subject=$row1['sub'];
								$message=$row1['body'];
								if($row1[$locale.'_sub']!='')
									$subject=$row1[$locale.'_sub'];
								if($row1[$locale.'_body']!='')
									$message=$row1[$locale.'_body'];
								$message=str_ireplace("{ENGINE}", Settings::get_instance()->read('engine_name'),$message);
								$subject=str_ireplace("{ENGINE}", Settings::get_instance()->read('engine_name'),$subject);
								
								$message=str_ireplace("{NEWPASSWORD}", $newpass,$message);
								
								UtilityHelper::send_mail($email, $subject, $message);
								$this->flash($this->get_message('password resetted'), $this->make_base_url('user/login_register'));
							}
						}
						
		
			 }
			 else
			 {
			       	$this->flash($this->get_message('demo mode'), $this->make_base_url('user/login_register'),0);
			       	exit;
			 }	
					
		}
		$this->set_variable("username",$username);
}
	
	
	function support_action()
	{
		
		//require_once LIB_DIR_PATH.'recaptchalib.php';
		require_once LIB_DIR_PATH.'recaptcha/autoload.php';
		
		
		$recaptcha_public_key=Settings::get_instance()->read('recaptcha_public_key');
		$this->set_variable('recaptcha_public_key',$recaptcha_public_key);
		
		
		
		
		$this->set_title($this->get_label('support'));
		$uid=$this->read_cookie_param(COOKIE_LOGINID);
		
		
		$this->set_variable('uid', $uid);
		$db= DBLayer::get_instance();
	
		
		if($_POST)
		{
			
			
			$xyz_email=Settings::get_instance()->read('general_notification_email');
			$email=$this->read_post_param('email');
			$subject=$this->read_post_param('subject');
			$query=$this->read_post_param('query');
			$captcha_val=0;
			$cap_flg=0;
			
			if((LoginHelper::validate_user_login()==0))
			{
				$usr=$this->get_label('new contact');

				if(Settings::get_instance()->read('enable_captcha_verification')==1)
				{
				    
				    $cap_flg=1;
				    $recaptcha_private_key = Settings::get_instance()->read('recaptcha_private_key');
				    if ($_POST["g-token"] !="")
				    {
				        $captcha = $this->read_post_param('g-token');
				        $captcha_val=$this->validate_captcha($captcha);
				        
				    }
				}
	
				
					
				$this->set_variable("emailenter",$email);	
					
			}
			else
			{
				
				$username=$this->read_cookie_param(COOKIE_USERNAME);
				$usr=$username."'s Support Request";
			}
			
			
			$this->set_variable("subject",$subject);
			$this->set_variable("query",$query);
		
			if($cap_flg ==1 && $captcha_val !=1)
			{
				$this->set_notice("check image verification");
			}
			else if($email =="" || $subject =="" || $query =="")
			{
				$this->set_notice("mandatory");
			}
			else if(!UtilityHelper::is_valid_email($email))
			{
				$this->set_notice("email format");
			}
			else 
			{
				
			$subject1=$usr."-".$subject;
			UtilityHelper::send_mail($xyz_email, $subject1, nl2br($query),"",$email,$email);
			
			$this->flash($this->get_message('query submitted'), $this->make_base_url('user/support'));
			exit;	
				
			}
				
		}
	}
	
	
	function other_listing_action()
	{
		$this->set_title($this->get_label('user listings'));
		$db= DBLayer::get_instance();
	
	
		if($_POST)
		{
			$type=$this->read_post_param("type");
			$featured=$this->read_post_param("featured");
			$categ=$this->read_post_param("catid");
			$user=intval($this->read_post_param("user"));
		}
		else
		{
			$type=-1;
			$featured=-1;
			$categ=0;
			$user=intval($this->read_page_param(1));
	
		}
	
	
		if(!$this->get_user_exists($user))
		{
			$this->flash($this->get_message('invalid id'), $this->make_url('category/items'),0);
			exit;
		}
		if(LoginHelper::validate_user_login() == false)
		{
		    $login=0;
		    $logusrid=0;
		}
		else
		{
		    $login=1;
		    $logusrid=intval($this->read_cookie_param(COOKIE_LOGINID));
		}
		$this->set_variable("logusrid",$logusrid);
		
		
		$res=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."users WHERE id=?",array($user));
		$row=$res->fetch_assoc();
		$user_name=$row['user_name'];
		$profile_pic=$row['profile_pic'];
		
		$this->set_variable("user_name",$user_name);
		$this->set_variable("profile_pic",$profile_pic);
	
		$userstatus=$db->read_single_column("SELECT status FROM ".TABLE_PREFIX."users WHERE id=?",array($user));
		if($userstatus !=1)
		{
			$this->flash($this->get_message('invalid operation'), $this->make_url('category/items'),0);
			exit;
		}
	
		
		if(Settings::get_instance()->read('language_enabled') ==1)
		{
			$localname='';
			if(isset($_COOKIE['my_locale']))
				$localname=$_COOKIE['my_locale'];
			$localeid=intval($this->get_locale_id($localname));
		}
		else
			$localeid=0;
		
		$this->set_variable('localeid',$localeid);
	
		$type_str="";
		$featured_str="";
		$cat_str="";
	
	
		if($type =="")
			$type=-1;
	
		if($featured =="")
			$featured=-1;
	
		if($categ =="")
			$categ=0;
	
	
	
		$this->set_variable("type",$type);
		$this->set_variable("featured",$featured);
		$this->set_variable("categ",$categ);
		$this->set_variable("user",$user);
	
	
		if($type !=-1)
			$type_str=" and type='".$type."' ";
	
		if($featured !=-1)
			$featured_str=" and featured='".$featured."' ";
	
		$astr="";
		if($categ !=0)
		{
			$childs=$this->display_childs($categ);
			$childs=substr($childs,0,-1);
	
			if($childs !="")
			{
				$cudata_arr=explode("_",$childs);
				if(count($cudata_arr) >0)
				{
					for($k=0;$k< count($cudata_arr); $k++)
					{
					$astr.=" ,$cudata_arr[$k] ";
		}
		}
		}
		$astr='and category IN ('.$categ.$astr.') ';
	}
	
	$order=Settings::get_instance()->read('item_display_order');
	
	$sql="select * from ".TABLE_PREFIX."items where user=? and status=1 ".$astr.$type_str.$featured_str." order by $order desc";
	$pagination = new Pagination($sql,array($user));
	$res=$pagination->get_result();
	$this->set_result("res",$res,array('summary'));
	$this->set_variable("pagination",$pagination->links(),0);
	
	
	$categories="<option value='0'>".$this->get_label('select')."</option>";
	$categories.=$this->get_category_display(0,0,$categ,$localeid);
	$this->set_variable("categories",$categories,0);
	
	}
	
function profile_action()
{
		$db= DBLayer::get_instance();
		$userid=$this->read_cookie_param(COOKIE_LOGINID);
		$flag=0;
		
	  if($_POST)
      {
		$pic_name=$_FILES['profile_pic']['name'];
		$profile_pic_tmp_name=$_FILES['profile_pic']['tmp_name'];
		$user_name=$this->read_post_param('user_name');
		$user_mobile=$this->read_post_param('user_mobile');
		$user_address=$this->read_post_param('user_address');
		
			
		if($pic_name)
		{
		    $propic_exten=strtolower(pathinfo($pic_name, PATHINFO_EXTENSION));
			if($pic_name!="" && $propic_exten!="jpg" && $propic_exten!="jpeg" && $propic_exten!="gif"  && $propic_exten!="png")
			{
			    $this->set_notice("image not supported");			
			}
		
		   else 
		   {
		   	$time=time();
		   	$profile_pic_name=$time.$propic_exten;
			$oldimage=$db->read_single_column("SELECT profile_pic from ".TABLE_PREFIX."users where id=?",array($userid));
			
			 
			
			 if(!is_dir(DS.DATA_DIR.DS.'profile_image'))
			 {
			         mkdir(DATA_DIR.DS.'profile_image',0777);
			 }
			
			 if(move_uploaded_file($profile_pic_tmp_name, DATA_DIR.DS.'profile_image'.DS.$userid.'_'.$profile_pic_name))
			 {
				    $newname=DATA_DIR.DS.'profile_image'.DS.$userid.'_'.$profile_pic_name;
				    $img_helper= new ImageHelper($newname);
				    $img_helper->resize_custom_limit(Settings::get_instance()->read('img_maxwt'),Settings::get_instance()->read('img_maxht'),$newname);
				    $img_helper->setImage($newname);
			
				    $db->execute_query("UPDATE ".TABLE_PREFIX."users SET user_name=?,user_mobile=?,user_address=?,profile_pic=? WHERE id=?",array($user_name,$user_mobile,$user_address,$profile_pic_name,$userid));
				  $flag=1;
				  if(file_exists(DATA_DIR.DS.'profile_image'.DS.$userid.'_'.$oldimage))
				  {
				      unlink(DATA_DIR.DS.'profile_image'.DS.$userid.'_'.$oldimage);
				      
				  }
			 }
			 else 
			 {
			     $flag=0;
				    $this->set_notice("image upload failed");
				    exit;
			 }
		   }
		}
		else 
		{
			$db->execute_query("UPDATE ".TABLE_PREFIX."users SET user_name=?,user_mobile=?,user_address=? WHERE id=?",array($user_name,$user_mobile,$user_address,$userid));
			$flag=1;
		}
		if($flag == 1)
		    $this->flash($this->get_message('update success'), $this->make_base_url('user/profile'));
	
    }
    else 
	   {
			$res=$db->execute_query("SELECT * FROM ".TABLE_PREFIX."users WHERE id=?",array($userid));
			$row=$res->fetch_assoc();
			$user_name=$row['user_name'];
			$user_address=$row['user_address'];
			$profile_pic=$row['profile_pic'];
			$user_mobile=$row['user_mobile'];
			$this->set_variable("profile_pic",$profile_pic);
		}
		$this->set_variable("user_id",$userid);
		$this->set_variable("user_name",$user_name);
		$this->set_variable("user_mobile",$user_mobile);
		$this->set_variable("user_address",$user_address);
		
		
	}
	function  my_favourites_action()
	{
	    
	    $this->set_title($this->get_label('user listings'));
	    $db= DBLayer::get_instance();
	    $logusrid=intval($this->read_cookie_param(COOKIE_LOGINID));
	    $this->set_variable("logusrid",$logusrid);
	    $favitemlist=array();
        $res=$db->execute_query("select * from ".TABLE_PREFIX."favourites where userid=?",array($logusrid));
	        
           
	    if($res->get_num_records() > 0)
	     {
	       $row=$res->fetch_assoc();
	       $id=$row['id'];
	       $userid=$row['userid'];
	       if($row['favitemlist'] !="")
	       {
	          $favitemlist=$row['favitemlist'];
	          $favitemlist_array=json_decode($favitemlist,true);
	          $favitemlist_array_count=count($favitemlist_array);
	          $favitemlist_array_new=array();
	          $countstr="";
	          if($favitemlist_array_count > 0)
	           {
                    for ($i = 1; $i <= $favitemlist_array_count; $i++)
                    {
	                   if($countstr !='')
	                       $countstr.=",";
	                   
	                   $countstr.="?";
	                 } 
	         
	                $sql="select * from ".TABLE_PREFIX."items where status=1 and id IN (".$countstr.") ";
	                $res1=$db->execute_query($sql,$favitemlist_array);
	           
	                while($data =$res1->fetch_assoc())
	                   {
	                       $favitemlist_array_new[]=$data['id'];
	                   }
	            
	                if(count($favitemlist_array_new) > 0)
	                   {
	                       $favitemlist_array_new=json_encode($favitemlist_array_new);
	                       $sql_update="UPDATE ".TABLE_PREFIX."favourites set favitemlist=? where userid=?";
	                       $db->execute_query($sql_update,array($favitemlist_array_new,$userid));
	                    }
	            
	               $pagination = new Pagination($sql,$favitemlist_array);
	               $res=$pagination->get_result();
	               $this->set_result("res",$res);
	               $this->set_variable("pagination",$pagination->links(),0);
	            }
	            
	        }
	     }
	      // else no records found view
	
	}
};
?>
