<?php

if(LoginHelper::validate_user_login())
{
	echo '<span style="color:red">'.$this->get_label('you are already logged in').'</span>';
	exit;
}
  		
if (!session_id()) {
    session_start();
}


use Facebook\Facebook;
use Facebook\Exceptions\FacebookResponseException;
use Facebook\Exceptions\FacebookSDKException;

/*
 * Configuration and setup Facebook SDK
 */
$appId         = Settings::get_instance()->read('fb_app_id');
$appSecret     = Settings::get_instance()->read('fb_secret');
$redirectURL   = $this->make_url('layout/facebooklogin'); 
$fbPermissions = array('email');  //Optional permissions

$fb = new Facebook(array(
    'app_id' => $appId,
    'app_secret' => $appSecret,
    'default_graph_version' => 'v4.0',
));

// Get redirect login helper
$helper = $fb->getRedirectLoginHelper();


// Try to get access token
try {
	////
	if(isset($_SESSION['facebook_access_token'])){
		$accessToken = $_SESSION['facebook_access_token'];
	}else{
	   
	    
		$accessToken = $helper->getAccessToken();
	}

} catch(FacebookResponseException $e) {
     echo 'Graph returned an error: ' . $e->getMessage();
      exit;
} catch(FacebookSDKException $e) {
    echo 'Facebook SDK returned an error: ' . $e->getMessage();
      exit;
}

if(isset($accessToken)){
	
	///////////////
	if(isset($_SESSION['facebook_access_token'])){
		$fb->setDefaultAccessToken($_SESSION['facebook_access_token']);
		
	}else{
		// Put short-lived access token in session
		$_SESSION['facebook_access_token'] = (string) $accessToken;
	
		// OAuth 2.0 client handler helps to manage access tokens
		$oAuth2Client = $fb->getOAuth2Client();
	
		// Exchanges a short-lived access token for a long-lived one
		$longLivedAccessToken = $oAuth2Client->getLongLivedAccessToken($_SESSION['facebook_access_token']);
		$_SESSION['facebook_access_token'] = (string) $longLivedAccessToken;
	
		// Set default access token to be used in script
		$fb->setDefaultAccessToken($_SESSION['facebook_access_token']);
		
		
	}
	
	
	}

	
	if(!isset($_GET['code']))
	{
	   
	    $loginURL = $helper->getLoginUrl($redirectURL, $fbPermissions);
	    
	    
	    header("location:".$loginURL);
	}


    try {
       
        $profileRequest = $fb->get('/me?fields=name,email');
        $fbUserProfile = $profileRequest->getGraphNode()->asArray();
        
       
        
    } 

    catch(FacebookResponseException $e) {
        echo 'Graph returned an error: ' . $e->getMessage();
        session_destroy();
        // Redirect user back to app login page
        header("Location: ./");
        exit;
    } 
    catch(FacebookSDKException $e) {
        echo 'Facebook SDK returned an error: ' . $e->getMessage();
        exit;
    }
   
    if(Settings::get_instance()->read('fb_login_enabled') ==1 && $fbUserProfile['email'] !="")
    {
        $email=$fbUserProfile['email'];
        $name=$fbUserProfile['name'];
    	$db= DBLayer::get_instance();
    
    	$countval=$db->read_single_column("SELECT id FROM ".TABLE_PREFIX."users WHERE email=?",array($email));
    	
    	
    	if($countval =="")
    	{
    	   
    		$enc_pwd=base64_encode(substr(md5($email),0,10));
    		
    		
    		$res=$db->execute_query("INSERT INTO ".TABLE_PREFIX."users (user_name,email,status,reg_time,last_login_time,password) values (?,?,?,?,?,?)",array($name,$email,1,time(),time(),$enc_pwd));
    		
    		
    		$id=$res->get_last_id();
    
    		$db->execute_query("INSERT INTO ".TABLE_PREFIX."notification (`uid`,`itemid`,`type`,`expiry`,`readed`) VALUES (?,?,?,?,?)",array($id,0,1,0,0));
    
    
    		setcookie(COOKIE_LOGINID,$id,0,$this->get_base_path(),$this->get_base_domain());
    		setcookie(COOKIE_SOCIALLOGIN,"fb",0,$this->get_base_path(),$this->get_base_domain());
    		setcookie(COOKIE_SOCIALLOGINEMAIL,$email,0,$this->get_base_path(),$this->get_base_domain());
    		
    		$this->login_update($id);
    
    	}
    	else
    	{
    	   
    		$res1=$db->execute_query("select * from ".TABLE_PREFIX."users where email=?",array($email));
    		$result1=$res1->fetch_assoc();
    		if($result1['status']==1)
    		{
    			$id=$result1['id'];
    
    			setcookie(COOKIE_LOGINID,$id,0,$this->get_base_path(),$this->get_base_domain());
    			setcookie(COOKIE_SOCIALLOGIN,"fb",0,$this->get_base_path(),$this->get_base_domain());
    			setcookie(COOKIE_SOCIALLOGINEMAIL,$email,0,$this->get_base_path(),$this->get_base_domain());
    
    			$this->login_update($id);
    		}
    	}
    }
    else if(Settings::get_instance()->read('fb_login_enabled') ==1 )
    {
        $this->flash($this->get_message('facebook returns with out email'), $this->make_base_url('user/login_register'),0);
    }


?>